/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.platform.Services;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;

public class BrandingRenderer {
    private final Font font;
    private float opacity = 1.0f;
    private final int screenHeight;
    private final List<Component> lines;

    public BrandingRenderer(int screenHeight) {
        this.font = Minecraft.m_91087_().f_91062_;
        this.screenHeight = screenHeight;
        this.lines = Services.COMPAT.getTitleScreenBrandingLines();
    }

    public BrandingRenderer setOpacity(float opacity) {
        this.opacity = opacity;
        return this;
    }

    public int getDefaultPositionX() {
        return 2;
    }

    public int getDefaultPositionY() {
        int totalHeight = this.getTotalHeight();
        int i = this.screenHeight - 2 - totalHeight;
        return ++i;
    }

    public int getTotalWidth() {
        int width = 0;
        for (Component line : this.lines) {
            int lineWidth = this.font.m_92852_((FormattedText)line);
            if (lineWidth <= width) continue;
            width = lineWidth;
        }
        return width;
    }

    public int getTotalHeight() {
        Objects.requireNonNull(this.font);
        int totalHeight = (9 + 1) * this.lines.size();
        if (totalHeight > 0) {
            --totalHeight;
        }
        return totalHeight;
    }

    public void render(@NotNull GuiGraphics graphics) {
        this.render(graphics, this.getDefaultPositionX(), this.getDefaultPositionY());
    }

    public void render(@NotNull GuiGraphics graphics, int x, int y) {
        RenderSystem.m_69478_();
        if (this.lines.isEmpty()) {
            return;
        }
        int currentY = y;
        for (Component line : this.lines) {
            graphics.drawString(this.font, line, x, currentY, DrawableColor.WHITE.getColorIntWithAlpha(this.opacity));
            Objects.requireNonNull(this.font);
            currentY += 9 + 1;
        }
    }
}

