/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;

public class MinecraftLogoRenderer {
    public static final MinecraftLogoRenderer DEFAULT_INSTANCE = new MinecraftLogoRenderer();
    private static final ResourceLocation MINECRAFT_LOGO = new ResourceLocation("textures/gui/title/minecraft.png");
    private static final ResourceLocation MINECRAFT_EDITION = new ResourceLocation("textures/gui/title/edition.png");
    private final boolean minceraftEasterEgg;

    public MinecraftLogoRenderer(boolean minceraftEasterEgg) {
        this.minceraftEasterEgg = minceraftEasterEgg;
    }

    public MinecraftLogoRenderer() {
        this((double)RandomSource.m_216327_().m_188501_() < 1.0E-4);
    }

    public void render(GuiGraphics graphics, int x, int y, float alpha) {
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.renderLogo(graphics, x, y, alpha);
        this.renderEdition(graphics, x + 88, y + 37, alpha);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void renderLogo(GuiGraphics graphics, int x, int y, float alpha) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        if (this.minceraftEasterEgg) {
            this.blitOutlineBlack(graphics, x, y, (logoX, logoY) -> {
                graphics.blit(MINECRAFT_LOGO, logoX + 0, logoY, 0, 0, 99, 44);
                graphics.blit(MINECRAFT_LOGO, logoX + 99, logoY, 129, 0, 27, 44);
                graphics.blit(MINECRAFT_LOGO, logoX + 99 + 26, logoY, 126, 0, 3, 44);
                graphics.blit(MINECRAFT_LOGO, logoX + 99 + 26 + 3, logoY, 99, 0, 26, 44);
                graphics.blit(MINECRAFT_LOGO, logoX + 155, logoY, 0, 45, 155, 44);
            }, alpha);
        } else {
            this.blitOutlineBlack(graphics, x, y, (logoX, logoY) -> {
                graphics.blit(MINECRAFT_LOGO, logoX + 0, logoY, 0, 0, 155, 44);
                graphics.blit(MINECRAFT_LOGO, logoX + 155, logoY, 0, 45, 155, 44);
            }, alpha);
        }
    }

    protected void renderEdition(GuiGraphics graphics, int x, int y, float alpha) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        graphics.blit(MINECRAFT_EDITION, x, y, 0.0f, 0.0f, 98, 14, 128, 16);
    }

    protected void blitOutlineBlack(GuiGraphics graphics, int x, int y, DrawLogo drawLogo, float alpha) {
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        drawLogo.draw(x + 1, y);
        drawLogo.draw(x - 1, y);
        drawLogo.draw(x, y + 1);
        drawLogo.draw(x, y - 1);
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        drawLogo.draw(x, y);
    }

    public int getLogoWidth() {
        return 274;
    }

    public int getLogoHeight() {
        return 44;
    }

    public int getEditionWidth() {
        return 98;
    }

    public int getEditionHeight() {
        return 14;
    }

    public int getTotalWidth() {
        return this.getLogoWidth();
    }

    public int getTotalHeight() {
        return 51;
    }

    @FunctionalInterface
    protected static interface DrawLogo {
        public void draw(int var1, int var2);
    }
}

