/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.melody.resources.audio.openal;

import de.keksuccino.melody.resources.audio.AudioClip;
import de.keksuccino.melody.resources.audio.MinecraftSoundSettingsObserver;
import de.keksuccino.melody.resources.audio.openal.ALAudioBuffer;
import de.keksuccino.melody.resources.audio.openal.ALErrorHandler;
import de.keksuccino.melody.resources.audio.openal.ALException;
import java.io.Closeable;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.sounds.SoundSource;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openal.AL10;

public class ALAudioClip
implements AudioClip {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final int source;
    @NotNull
    protected SoundSource soundChannel = SoundSource.MASTER;
    protected float volume = 1.0f;
    protected long volumeListenerId;
    protected boolean closeQuietly = false;
    protected volatile boolean closed = false;

    @Nullable
    public static ALAudioClip of(@NotNull ALAudioBuffer completeStaticDataBuffer) {
        Objects.requireNonNull(completeStaticDataBuffer);
        ALAudioClip clip = ALAudioClip.create();
        if (clip != null) {
            try {
                clip.setStaticBuffer(completeStaticDataBuffer);
                return clip;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    @Nullable
    public static ALAudioClip create() {
        int[] audioSource = new int[1];
        AL10.alGenSources((int[])audioSource);
        try {
            ALErrorHandler.checkOpenAlError();
            return new ALAudioClip(audioSource[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected ALAudioClip(int source) {
        this.source = source;
        this.volumeListenerId = MinecraftSoundSettingsObserver.registerVolumeListener((soundSource, newVolume) -> {
            if (soundSource == this.soundChannel) {
                this.tryUpdateVolume();
            }
        });
        this.tryUpdateVolume();
    }

    public int getState() throws ALException {
        if (this.closed) {
            return 4116;
        }
        int state = AL10.alGetSourcei((int)this.source, (int)4112);
        ALErrorHandler.checkOpenAlError();
        return state;
    }

    @Override
    public void play() throws ALException {
        if (this.closed) {
            return;
        }
        if (!this.isPlaying()) {
            AL10.alSourcePlay((int)this.source);
        }
        ALErrorHandler.checkOpenAlError();
    }

    @Override
    public boolean isPlaying() throws ALException {
        return this.getState() == 4114;
    }

    @Override
    public void stop() throws ALException {
        if (this.closed) {
            return;
        }
        if (!this.isStopped()) {
            AL10.alSourceStop((int)this.source);
            ALErrorHandler.checkOpenAlError();
        }
    }

    public boolean isStopped() throws ALException {
        return this.getState() == 4116;
    }

    @Override
    public void pause() throws ALException {
        if (this.closed) {
            return;
        }
        if (this.isPlaying()) {
            AL10.alSourcePause((int)this.source);
            ALErrorHandler.checkOpenAlError();
        }
    }

    @Override
    public void resume() throws ALException {
        if (this.closed) {
            return;
        }
        if (this.isPaused()) {
            AL10.alSourcePlay((int)this.source);
            ALErrorHandler.checkOpenAlError();
        }
    }

    @Override
    public boolean isPaused() throws ALException {
        return this.getState() == 4115;
    }

    public void setLooping(boolean looping) throws ALException {
        if (this.closed) {
            return;
        }
        AL10.alSourcei((int)this.source, (int)4103, (int)(looping ? 1 : 0));
        ALErrorHandler.checkOpenAlError();
    }

    public boolean isLooping() throws ALException {
        if (this.closed) {
            return false;
        }
        boolean loop = AL10.alGetSourcei((int)this.source, (int)4103) == 1;
        ALErrorHandler.checkOpenAlError();
        return loop;
    }

    @Override
    public void setVolume(float volume) throws ALException {
        if (this.closed) {
            return;
        }
        if (volume > 1.0f) {
            volume = 1.0f;
        }
        if (volume < 0.0f) {
            volume = 0.0f;
        }
        float actualVolume = this.volume = volume;
        if (this.soundChannel != SoundSource.MASTER) {
            float soundSourceVolume = Minecraft.m_91087_().f_91066_.m_92147_(this.soundChannel);
            actualVolume *= soundSourceVolume;
        }
        AL10.alSourcef((int)this.source, (int)4106, (float)Math.min(1.0f, Math.max(0.0f, actualVolume)));
        ALErrorHandler.checkOpenAlError();
    }

    @Override
    public float getVolume() {
        if (this.closed) {
            return 0.0f;
        }
        return this.volume;
    }

    public void tryUpdateVolume() {
        try {
            this.setVolume(this.volume);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setSoundChannel(@NotNull SoundSource channel) {
        this.soundChannel = Objects.requireNonNull(channel);
        this.tryUpdateVolume();
    }

    @Override
    @NotNull
    public SoundSource getSoundChannel() {
        return this.soundChannel;
    }

    public void setStaticBuffer(@NotNull ALAudioBuffer completeDataBuffer) throws ALException {
        if (this.closed) {
            return;
        }
        Integer buffer = completeDataBuffer.getSource();
        if (buffer != null) {
            AL10.alSourcei((int)this.source, (int)4105, (int)buffer);
            ALErrorHandler.checkOpenAlError();
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            MinecraftSoundSettingsObserver.unregisterVolumeListener(this.volumeListenerId);
            if (this.isValidOpenAlSource()) {
                AL10.alSourceStop((int)this.source);
                if (this.closeQuietly) {
                    ALErrorHandler.getOpenAlError();
                } else {
                    ALErrorHandler.checkAndPrintOpenAlError();
                }
                AL10.alDeleteSources((int[])new int[]{this.source});
                if (this.closeQuietly) {
                    ALErrorHandler.getOpenAlError();
                } else {
                    ALErrorHandler.checkAndPrintOpenAlError();
                }
            }
        }
    }

    public void closeQuietly() {
        if (this.closed) {
            return;
        }
        this.closeQuietly = true;
        IOUtils.closeQuietly((Closeable)this);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public boolean isValidOpenAlSource() {
        return AL10.alIsSource((int)this.source);
    }
}

