/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores;

import com.mojang.logging.LogUtils;
import com.simibubi.create.content.kinetics.BlockStressValues;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.tom.createores.COECommand;
import com.tom.createores.Config;
import com.tom.createores.ForgeConfig;
import com.tom.createores.OreDataCapability;
import com.tom.createores.OreVeinGenerator;
import com.tom.createores.Registration;
import com.tom.createores.client.ClientRegistration;
import com.tom.createores.recipe.DrillingRecipe;
import com.tom.createores.recipe.ExcavatingRecipe;
import com.tom.createores.recipe.ExtractorRecipe;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="createoreexcavation")
public class CreateOreExcavation {
    public static final String MODID = "createoreexcavation";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static CreateRegistrate registrate;
    private static final DeferredRegister<MenuType<?>> MENU_TYPE;
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZER;
    private static final DeferredRegister<RecipeType<?>> TYPE_REGISTER;
    public static final RecipeTypeGroup<DrillingRecipe> DRILLING_RECIPES;
    public static final RecipeTypeGroup<ExtractorRecipe> EXTRACTING_RECIPES;
    public static final CreativeModeTab MOD_TAB;
    public static final TagKey<Item> DRILL_TAG;

    public CreateOreExcavation() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        registrate = CreateRegistrate.create((String)MODID).registerEventListeners(FMLJavaModLoadingContext.get().getModEventBus());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        FMLJavaModLoadingContext.get().getModEventBus().register(ForgeConfig.class);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Registration.register();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        MENU_TYPE.register(bus);
        RECIPE_SERIALIZER.register(bus);
        TYPE_REGISTER.register(bus);
    }

    private static <T extends ExcavatingRecipe> RecipeTypeGroup<T> recipe(String name, ExcavatingRecipe.Serializer.RecipeFactory<T> factory) {
        RecipeTypeGroup rg = new RecipeTypeGroup(new ResourceLocation(MODID, name));
        rg.recipeType = TYPE_REGISTER.register(name, () -> RecipeType.simple((ResourceLocation)new ResourceLocation(MODID, name)));
        rg.serializer = RECIPE_SERIALIZER.register(name, () -> new ExcavatingRecipe.Serializer(rg, factory));
        return rg;
    }

    private static <M extends AbstractContainerMenu> RegistryObject<MenuType<M>> menu(String name, MenuType.MenuSupplier<M> create) {
        return MENU_TYPE.register(name, () -> new MenuType(create));
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Create Ore Excavation starting");
        Registration.postRegister();
        BlockStressValues.registerProvider((String)MODID, (BlockStressValues.IStressValueProvider)AllConfigs.server().kinetics.stressValues);
        COECommand.init();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        event.enqueueWork(ClientRegistration::register);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent evt) {
        COECommand.register(evt);
    }

    @SubscribeEvent
    public void onAttachCapabilitiesChunk(AttachCapabilitiesEvent<LevelChunk> event) {
        if (!((LevelChunk)event.getObject()).getCapability(OreDataCapability.ORE_CAP).isPresent()) {
            event.addCapability(new ResourceLocation(MODID, "ore_data"), (ICapabilityProvider)new OreDataCapability());
        }
    }

    @SubscribeEvent
    public void reloadEvent(TagsUpdatedEvent evt) {
        OreVeinGenerator.invalidate();
    }

    public static CreateRegistrate registrate() {
        return registrate;
    }

    static {
        MENU_TYPE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)MODID);
        RECIPE_SERIALIZER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)MODID);
        TYPE_REGISTER = DeferredRegister.create((ResourceKey)Registry.f_122914_, (String)MODID);
        DRILLING_RECIPES = CreateOreExcavation.recipe("drilling", DrillingRecipe::new);
        EXTRACTING_RECIPES = CreateOreExcavation.recipe("extracting", ExtractorRecipe::new);
        MOD_TAB = new CreativeModeTab("createoreexcavation.tab"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)Registration.DIAMOND_DRILL_ITEM.get());
            }
        };
        DRILL_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(MODID, "drills"));
    }

    public static class RecipeTypeGroup<T extends Recipe<?>> {
        private RegistryObject<RecipeSerializer<T>> serializer;
        private RegistryObject<RecipeType<T>> recipeType;
        private ResourceLocation id;

        public RecipeTypeGroup(ResourceLocation id) {
            this.id = id;
        }

        public RecipeType<T> getRecipeType() {
            return (RecipeType)this.recipeType.get();
        }

        public RecipeSerializer<T> getSerializer() {
            return (RecipeSerializer)this.serializer.get();
        }

        public ResourceLocation getId() {
            return this.id;
        }
    }
}

