/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores;

import com.tom.createores.Config;
import com.tom.createores.OreVeinGenerator;
import com.tom.createores.block.entity.IDrill;
import com.tom.createores.recipe.IRecipe;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class OreDataCapability
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static Capability<OreData> ORE_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<OreData>(){});
    private OreData oreData = null;
    private final LazyOptional<OreData> opt = LazyOptional.of(this::create);

    private OreData create() {
        if (this.oreData == null) {
            this.oreData = new OreData();
        }
        return this.oreData;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap) {
        if (cap == ORE_CAP) {
            return this.opt.cast();
        }
        return LazyOptional.empty();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return this.getCapability(cap);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.create().saveNBTData(nbt);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.create().loadNBTData(nbt);
    }

    public static OreData getData(LevelChunk chunk) {
        if (chunk.m_62953_().f_46443_) {
            throw new RuntimeException("Ore Data accessed from client");
        }
        OreData data = (OreData)chunk.getCapability(ORE_CAP).orElse(null);
        if (data != null && !data.loaded) {
            RandomSource rng = OreVeinGenerator.rngFromChunk(chunk);
            IRecipe r = OreVeinGenerator.pick(chunk, rng);
            if (r != null) {
                data.recipe = r.getRecipeId();
                data.randomMul = rng.m_188501_();
            }
            data.loaded = true;
        }
        return data;
    }

    public static class OreData {
        private ResourceLocation recipe;
        private boolean loaded;
        private long extractedAmount;
        private float randomMul;
        private Set<BlockPos> extractors;

        public void loadNBTData(CompoundTag nbt) {
            this.loaded = nbt.m_128471_("gen");
            if (nbt.m_128441_("ore")) {
                this.recipe = new ResourceLocation(nbt.m_128461_("ore"));
                this.extractedAmount = nbt.m_128454_("ext");
                this.randomMul = nbt.m_128441_("mul") ? nbt.m_128457_("mul") : 0.8f;
            }
        }

        public void saveNBTData(CompoundTag nbt) {
            nbt.m_128379_("gen", this.loaded);
            if (this.recipe != null) {
                nbt.m_128359_("ore", this.recipe.toString());
                nbt.m_128356_("ext", this.extractedAmount);
                nbt.m_128350_("mul", this.randomMul);
            }
        }

        public void setRecipe(ResourceLocation recipe) {
            this.recipe = recipe;
        }

        public ResourceLocation getRecipeId() {
            return this.recipe;
        }

        public IRecipe getRecipe(RecipeManager mngr) {
            return mngr.m_44043_(this.recipe).filter(r -> r instanceof IRecipe).map(r -> (IRecipe)r).orElse(null);
        }

        public boolean isLoaded() {
            return this.loaded;
        }

        public long getResourcesRemaining(IRecipe r) {
            IRecipe.IResourceRecipe rr;
            if (r instanceof IRecipe.IResourceRecipe && (rr = (IRecipe.IResourceRecipe)((Object)r)).isFinite() != IRecipe.ThreeState.NEVER) {
                if (rr.isFinite() == IRecipe.ThreeState.DEFAULT && Config.defaultInfinite) {
                    return 0L;
                }
                double mul = (rr.getMaxAmount() - rr.getMinAmount()) * this.randomMul + rr.getMinAmount();
                long am = Math.round(mul * (double)Config.finiteAmountBase);
                if (this.extractedAmount >= am) {
                    return -1L;
                }
                return am - this.extractedAmount;
            }
            return 0L;
        }

        public void extract(int a) {
            this.extractedAmount += (long)a;
        }

        public boolean canExtract(Level lvl, BlockPos pos) {
            if (Config.maxExtractorsPerVein == 0) {
                return true;
            }
            if (this.extractors == null) {
                this.extractors = new HashSet<BlockPos>();
                this.extractors.add(pos);
                return true;
            }
            if (this.extractors.contains(pos)) {
                return true;
            }
            this.extractors.removeIf(p -> !(lvl.m_7702_(p) instanceof IDrill));
            if (this.extractors.size() < Config.maxExtractorsPerVein) {
                this.extractors.add(pos);
                return true;
            }
            return false;
        }

        public void setRandomMul(float randomMul) {
            this.randomMul = randomMul;
        }

        public void setLoaded(boolean loaded) {
            this.loaded = loaded;
        }

        public void setExtractedAmount(long extractedAmount) {
            this.extractedAmount = extractedAmount;
        }
    }
}

