/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.block.entity;

import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.tom.createores.block.entity.ExcavatingBlockEntity;
import com.tom.createores.recipe.DrillingRecipe;
import com.tom.createores.util.IOBlockType;
import com.tom.createores.util.QueueInventory;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class DrillBlockEntity
extends ExcavatingBlockEntity<DrillingRecipe> {
    private QueueInventory inventory = new QueueInventory();
    private FluidTank fluidTank = new FluidTank(16000, v -> this.current != null && ((DrillingRecipe)this.current).getDrillingFluid().test(v)){

        protected void onContentsChanged() {
            DrillBlockEntity.this.notifyUpdate();
        }
    };
    private LazyOptional<FluidTank> tankCap = LazyOptional.of(() -> this.fluidTank);

    public DrillBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public <T> LazyOptional<T> getCaps(Capability<T> cap, IOBlockType type) {
        if (type == IOBlockType.ITEM_OUT && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventory.asCap();
        }
        if (type == IOBlockType.FLUID_IN && cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.tankCap.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.fluidTank.readFromNBT(tag.m_128469_("tank"));
        if (!clientPacket) {
            this.inventory.load(tag.m_128437_("inv", 10));
        }
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128365_("tank", (Tag)this.fluidTank.writeToNBT(new CompoundTag()));
        if (!clientPacket) {
            tag.m_128365_("inv", (Tag)this.inventory.toTag());
        }
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        this.containedFluidTooltip(tooltip, isPlayerSneaking, this.tankCap.cast());
        return true;
    }

    @Override
    public void addToGoggleTooltip(List<Component> tooltip, DrillingRecipe rec) {
        if (rec.getDrillingFluid().getRequiredAmount() != 0 && rec.getDrillingFluid().test(this.fluidTank.getFluid()) && this.fluidTank.getFluidAmount() >= rec.getDrillingFluid().getRequiredAmount()) {
            tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"info.coe.drill.noFluid")));
        }
    }

    public void invalidate() {
        super.invalidate();
        this.inventory.invalidate();
        this.tankCap.invalidate();
    }

    @Override
    public void dropInv() {
        super.dropInv();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.dropItemStack(this.inventory.getStackInSlot(i));
        }
    }

    @Override
    protected boolean instanceofCheck(Object rec) {
        return rec instanceof DrillingRecipe;
    }

    @Override
    protected boolean canExtract() {
        return this.inventory.hasSpace() && ((DrillingRecipe)this.current).getDrillingFluid().getRequiredAmount() == 0 || ((DrillingRecipe)this.current).getDrillingFluid().test(this.fluidTank.getFluid()) && this.fluidTank.getFluidAmount() >= ((DrillingRecipe)this.current).getDrillingFluid().getRequiredAmount();
    }

    @Override
    protected void onFinished() {
        ((DrillingRecipe)this.current).getOutput().stream().map(ProcessingOutput::rollOutput).filter(i -> !i.m_41619_()).forEach(this.inventory::add);
        this.fluidTank.drain(((DrillingRecipe)this.current).getDrillingFluid().getRequiredAmount(), IFluidHandler.FluidAction.EXECUTE);
    }
}

