/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.tom.createores.jei.AnimatedBlock;
import com.tom.createores.jei.ItemIcon;
import com.tom.createores.recipe.ExcavatingRecipe;
import com.tom.createores.util.BiomeTooltip;
import com.tom.createores.util.NumberFormatter;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public abstract class ExcavatingCategory<T extends ExcavatingRecipe>
implements IRecipeCategory<T> {
    protected AnimatedBlock block;
    protected IDrawable background = new EmptyBackground(177, 100);
    protected IDrawable icon;
    protected IDrawable biomeWIcon = new ItemIcon(() -> new ItemStack((ItemLike)Items.f_42799_));
    protected IDrawable biomeBIcon = new DoubleItemIcon(() -> new ItemStack((ItemLike)Items.f_42799_), () -> new ItemStack((ItemLike)Items.f_42127_));

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 51, 3).setBackground(CreateRecipeCategory.getRenderedSlot(), -1, -1).addIngredients(((ExcavatingRecipe)recipe).getDrill());
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        this.block.draw(stack, 48, 35);
        this.biomeWIcon.draw(stack, 100, 5);
        this.biomeBIcon.draw(stack, 100, 25);
    }

    public List<Component> getTooltipStrings(T recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (mouseX > 100.0 && mouseX < 118.0) {
            if (mouseY > 5.0 && mouseY < 23.0) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.coe.biome.whitelist"));
                BiomeTooltip.listBiomes(((ExcavatingRecipe)recipe).biomeWhitelist, tooltip);
            } else if (mouseY > 25.0 && mouseY < 43.0) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.coe.biome.blacklist"));
                BiomeTooltip.listBiomes(((ExcavatingRecipe)recipe).biomeBlacklist, tooltip);
            } else {
                BiomeTooltip.resetPage();
            }
        }
        if (mouseX > 40.0 && mouseX < 80.0 && mouseY > 25.0 && mouseY < 60.0) {
            tooltip.add(((ExcavatingRecipe)recipe).getName());
            tooltip.add((Component)Component.m_237110_((String)"tooltip.coe.processTime", (Object[])new Object[]{((ExcavatingRecipe)recipe).getTicks()}));
            if (((ExcavatingRecipe)recipe).isInfiniteClient()) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.coe.infiniteVeins"));
            } else {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.coe.finiteVeins", (Object[])new Object[]{NumberFormatter.formatNumber(((ExcavatingRecipe)recipe).getMinAmountClient()), NumberFormatter.formatNumber(((ExcavatingRecipe)recipe).getMaxAmountClient())}));
            }
        }
        return tooltip;
    }
}

