/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.item.SmartInventory;
import com.tom.createores.Config;
import com.tom.createores.CreateOreExcavation;
import com.tom.createores.recipe.IRecipe;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public abstract class ExcavatingRecipe
implements Recipe<SmartInventory>,
IRecipe,
IRecipe.IResourceRecipe {
    public ResourceLocation id;
    public RecipeType<?> type;
    public RecipeSerializer<?> serializer;
    public Ingredient drill;
    public int weight;
    public int ticks;
    public int stressMul;
    public Component veinName;
    public TagKey<Biome> biomeWhitelist;
    public TagKey<Biome> biomeBlacklist;
    public IRecipe.ThreeState finite;
    public float amountMultiplierMin;
    public float amountMultiplierMax;
    protected boolean isNet;

    public ExcavatingRecipe(ResourceLocation id, RecipeType<?> type, RecipeSerializer<?> serializer) {
        this.id = id;
        this.type = type;
        this.serializer = serializer;
    }

    public boolean matches(SmartInventory pContainer, Level pLevel) {
        return false;
    }

    public ItemStack assemble(SmartInventory pContainer) {
        return this.m_8043_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return this.serializer;
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    public Ingredient getDrill() {
        return this.drill;
    }

    public int getTicks() {
        return this.ticks;
    }

    public abstract String m_6076_();

    @Override
    public ResourceLocation getRecipeId() {
        return this.id;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public Component getName() {
        return this.veinName;
    }

    public int getStress() {
        return this.stressMul;
    }

    @Override
    public boolean canGenerate(ServerLevel lvl, Holder<Biome> b) {
        if (this.biomeBlacklist != null && ExcavatingRecipe.isInTag(this.biomeBlacklist, lvl, b)) {
            return false;
        }
        if (this.biomeWhitelist != null) {
            return ExcavatingRecipe.isInTag(this.biomeWhitelist, lvl, b);
        }
        return true;
    }

    private static boolean isInTag(TagKey<Biome> tag, ServerLevel lvl, Holder<Biome> b) {
        return lvl.m_7654_().m_206579_().m_175515_(Registry.f_122885_).m_203431_(tag).map(t -> t.m_203333_(b)).orElse(false);
    }

    @Override
    public IRecipe.ThreeState isFinite() {
        return this.finite;
    }

    @Override
    public float getMinAmount() {
        return this.amountMultiplierMin;
    }

    @Override
    public float getMaxAmount() {
        return this.amountMultiplierMax;
    }

    protected abstract void fromJson(JsonObject var1);

    protected abstract void toJson(JsonObject var1);

    protected abstract void fromNetwork(FriendlyByteBuf var1);

    protected abstract void toNetwork(FriendlyByteBuf var1);

    public boolean isInfiniteClient() {
        return this.isNet ? this.finite == IRecipe.ThreeState.NEVER : (this.finite == IRecipe.ThreeState.DEFAULT ? Config.defaultInfinite : this.finite == IRecipe.ThreeState.NEVER);
    }

    public long getMinAmountClient() {
        return Math.round(this.isNet ? (double)this.amountMultiplierMin : (double)this.amountMultiplierMin * (double)Config.finiteAmountBase);
    }

    public long getMaxAmountClient() {
        return Math.round(this.isNet ? (double)this.amountMultiplierMax : (double)this.amountMultiplierMax * (double)Config.finiteAmountBase);
    }

    public static class Serializer<T extends ExcavatingRecipe>
    implements RecipeSerializer<T> {
        private static final ResourceLocation NULL = new ResourceLocation("coe:null");
        private final CreateOreExcavation.RecipeTypeGroup<?> type;
        private final RecipeFactory<T> create;

        public Serializer(CreateOreExcavation.RecipeTypeGroup<?> type, RecipeFactory<T> create) {
            this.type = type;
            this.create = create;
        }

        public T fromJson(ResourceLocation pRecipeId, JsonObject json) {
            ResourceLocation resourcelocation;
            T r = this.create.create(pRecipeId, this.type.getRecipeType(), this);
            ((ExcavatingRecipe)r).drill = Ingredient.m_43917_((JsonElement)json.get("drill"));
            ((ExcavatingRecipe)r).veinName = Component.Serializer.m_130701_((String)json.get("name").getAsString());
            ((ExcavatingRecipe)r).weight = GsonHelper.m_13927_((JsonObject)json, (String)"weight");
            ((ExcavatingRecipe)r).ticks = GsonHelper.m_13927_((JsonObject)json, (String)"ticks");
            if (json.has("biomeWhitelist")) {
                resourcelocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"biomeWhitelist"));
                ((ExcavatingRecipe)r).biomeWhitelist = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)resourcelocation);
            }
            if (json.has("biomeBlacklist")) {
                resourcelocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"biomeBlacklist"));
                ((ExcavatingRecipe)r).biomeBlacklist = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)resourcelocation);
            }
            ((ExcavatingRecipe)r).stressMul = GsonHelper.m_13824_((JsonObject)json, (String)"stress", (int)256);
            ((ExcavatingRecipe)r).finite = IRecipe.ThreeState.get(json, "Finite");
            ((ExcavatingRecipe)r).amountMultiplierMin = GsonHelper.m_13820_((JsonObject)json, (String)"amountMin", (float)1.0f);
            ((ExcavatingRecipe)r).amountMultiplierMax = GsonHelper.m_13820_((JsonObject)json, (String)"amountMax", (float)2.0f);
            ((ExcavatingRecipe)r).fromJson(json);
            return r;
        }

        public void toJson(T recipe, JsonObject json) {
            json.add("drill", ((ExcavatingRecipe)recipe).drill.m_43942_());
            json.addProperty("name", Component.Serializer.m_130703_((Component)((ExcavatingRecipe)recipe).veinName));
            json.addProperty("weight", (Number)((ExcavatingRecipe)recipe).weight);
            json.addProperty("ticks", (Number)((ExcavatingRecipe)recipe).ticks);
            if (((ExcavatingRecipe)recipe).biomeWhitelist != null) {
                json.addProperty("biomeWhitelist", ((ExcavatingRecipe)recipe).biomeWhitelist.f_203868_().toString());
            }
            if (((ExcavatingRecipe)recipe).biomeBlacklist != null) {
                json.addProperty("biomeBlacklist", ((ExcavatingRecipe)recipe).biomeBlacklist.f_203868_().toString());
            }
            json.addProperty("stress", (Number)((ExcavatingRecipe)recipe).stressMul);
            ((ExcavatingRecipe)recipe).finite.toJson(json, "Finite");
            json.addProperty("amountMin", (Number)Float.valueOf(((ExcavatingRecipe)recipe).amountMultiplierMin));
            json.addProperty("amountMax", (Number)Float.valueOf(((ExcavatingRecipe)recipe).amountMultiplierMax));
            ((ExcavatingRecipe)recipe).toJson(json);
        }

        public T fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf buffer) {
            T r = this.create.create(pRecipeId, this.type.getRecipeType(), this);
            ((ExcavatingRecipe)r).drill = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ((ExcavatingRecipe)r).ticks = buffer.m_130242_();
            ((ExcavatingRecipe)r).weight = buffer.m_130242_();
            ((ExcavatingRecipe)r).veinName = buffer.m_130238_();
            ((ExcavatingRecipe)r).biomeWhitelist = Serializer.create(buffer);
            ((ExcavatingRecipe)r).biomeBlacklist = Serializer.create(buffer);
            ((ExcavatingRecipe)r).stressMul = buffer.m_130242_();
            ((ExcavatingRecipe)r).fromNetwork(buffer);
            ((ExcavatingRecipe)r).finite = buffer.readBoolean() ? IRecipe.ThreeState.ALWAYS : IRecipe.ThreeState.NEVER;
            ((ExcavatingRecipe)r).amountMultiplierMin = buffer.readFloat();
            ((ExcavatingRecipe)r).amountMultiplierMax = buffer.readFloat();
            ((ExcavatingRecipe)r).isNet = true;
            return r;
        }

        private static TagKey<Biome> create(FriendlyByteBuf buffer) {
            ResourceLocation rl = buffer.m_130281_();
            if (NULL.equals((Object)rl)) {
                return null;
            }
            return TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)rl);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            ((ExcavatingRecipe)recipe).drill.m_43923_(buffer);
            buffer.m_130130_(((ExcavatingRecipe)recipe).ticks);
            buffer.m_130130_(((ExcavatingRecipe)recipe).weight);
            buffer.m_130083_(((ExcavatingRecipe)recipe).veinName);
            Serializer.write(((ExcavatingRecipe)recipe).biomeWhitelist, buffer);
            Serializer.write(((ExcavatingRecipe)recipe).biomeBlacklist, buffer);
            buffer.m_130130_(((ExcavatingRecipe)recipe).stressMul);
            ((ExcavatingRecipe)recipe).toNetwork(buffer);
            buffer.writeBoolean(((ExcavatingRecipe)recipe).finite == IRecipe.ThreeState.DEFAULT ? !Config.defaultInfinite : ((ExcavatingRecipe)recipe).finite == IRecipe.ThreeState.ALWAYS);
            buffer.writeFloat(((ExcavatingRecipe)recipe).amountMultiplierMin * (float)Config.finiteAmountBase);
            buffer.writeFloat(((ExcavatingRecipe)recipe).amountMultiplierMax * (float)Config.finiteAmountBase);
        }

        private static void write(TagKey<Biome> tag, FriendlyByteBuf buffer) {
            buffer.m_130085_(tag != null ? tag.f_203868_() : NULL);
        }

        @FunctionalInterface
        public static interface RecipeFactory<T extends ExcavatingRecipe> {
            public T create(ResourceLocation var1, RecipeType<?> var2, RecipeSerializer<?> var3);
        }
    }
}

