/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.createindustry.blocks.cogwheeels;

import com.drmangotea.createindustry.blocks.cogwheeels.TFMGCogwheelRenderer;
import com.drmangotea.createindustry.registry.TFMGBlocks;
import com.drmangotea.createindustry.registry.TFMGPartialModels;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.base.SingleRotatingInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.content.kinetics.simpleRelays.SimpleKineticBlockEntity;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TFMGCogwheelInstance
extends SingleRotatingInstance<SimpleKineticBlockEntity> {
    protected RotatingData additionalShaft;

    public TFMGCogwheelInstance(MaterialManager materialManager, SimpleKineticBlockEntity blockEntity) {
        super(materialManager, (KineticBlockEntity)blockEntity);
    }

    public void init() {
        super.init();
        if (!ICogWheel.isLargeCog((BlockState)((SimpleKineticBlockEntity)this.blockEntity).m_58900_())) {
            return;
        }
        float speed = ((SimpleKineticBlockEntity)this.blockEntity).getSpeed();
        Direction.Axis axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)((KineticBlockEntity)this.blockEntity));
        BlockPos pos = ((SimpleKineticBlockEntity)this.blockEntity).m_58899_();
        float offset = BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)axis, (BlockPos)pos);
        Direction facing = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        Instancer half = this.getRotatingMaterial().getModel(AllPartialModels.COGWHEEL_SHAFT, this.blockState, facing, () -> this.rotateToAxis(axis));
        this.additionalShaft = this.setup((RotatingData)half.createInstance(), speed);
        this.additionalShaft.setRotationOffset(offset);
    }

    protected Instancer<RotatingData> getModel() {
        Direction.Axis axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)((KineticBlockEntity)this.blockEntity));
        Direction facing = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        if (!ICogWheel.isLargeCog((BlockState)((SimpleKineticBlockEntity)this.blockEntity).m_58900_())) {
            return this.getCutoutRotatingMaterial().getModel(this.blockState);
        }
        PartialModel model = ((SimpleKineticBlockEntity)this.blockEntity).m_58900_().m_60713_((Block)TFMGBlocks.LARGE_ALUMINUM_COGWHEEL.get()) ? TFMGPartialModels.LARGE_ALUMINUM_COGHWEEL : TFMGPartialModels.LARGE_STEEL_COGHWEEL;
        return this.getCutoutRotatingMaterial().getModel(model, this.blockState, facing, () -> this.rotateToAxis(axis));
    }

    protected Material<RotatingData> getCutoutRotatingMaterial() {
        return this.materialManager.defaultCutout().material(AllMaterialSpecs.ROTATING);
    }

    private PoseStack rotateToAxis(Direction.Axis axis) {
        Direction facing = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        PoseStack poseStack = new PoseStack();
        ((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)poseStack).centre()).rotateToFace(facing)).multiply(Vector3f.f_122222_.m_122240_(-90.0f))).unCentre();
        return poseStack;
    }

    public void update() {
        super.update();
        if (this.additionalShaft != null) {
            this.updateRotation(this.additionalShaft);
            this.additionalShaft.setRotationOffset(TFMGCogwheelRenderer.getShaftAngleOffset(this.axis, this.pos));
        }
    }

    public void updateLight() {
        super.updateLight();
        if (this.additionalShaft != null) {
            this.relight(this.pos, new FlatLit[]{this.additionalShaft});
        }
    }

    public void remove() {
        super.remove();
        if (this.additionalShaft != null) {
            this.additionalShaft.delete();
        }
    }
}

