/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.createindustry.blocks.electricity.base.cables;

import com.drmangotea.createindustry.CreateTFMG;
import com.drmangotea.createindustry.blocks.electricity.base.cables.ElectricNetworkManager;
import com.drmangotea.createindustry.blocks.electricity.base.cables.IElectric;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import java.util.ArrayList;
import java.util.List;

public class ElectricalNetwork {
    public List<IElectric> members = new ArrayList<IElectric>();
    public long id;
    public int voltage = 0;

    public ElectricalNetwork(long id) {
        this.id = id;
    }

    public void updateNetworkVoltage() {
        int maxVoltage = 0;
        for (IElectric member : this.members) {
            if (member.destroyed()) continue;
            maxVoltage = Math.max(member.voltageGeneration(), maxVoltage);
        }
        this.voltage = maxVoltage;
        this.updateVoltageFromNetwork();
    }

    public void updateVoltageFromNetwork() {
        for (IElectric member : this.members) {
            member.needsVoltageUpdate();
        }
    }

    public void add(IElectric be) {
        ArrayList posList = new ArrayList();
        this.members.forEach(member -> posList.add(member.getId()));
        if (posList.contains(be.getId())) {
            return;
        }
        this.members.add(be);
    }

    public void requestEnergy(SmartBlockEntity blockEntity) {
        if (blockEntity instanceof IElectric) {
            IElectric be = (IElectric)blockEntity;
            for (IElectric member : this.members) {
                if (member.getForgeEnergy() == null || member.equals(be) || this.voltage == 0 || !member.outputAllowed() || member.getForgeEnergy().getEnergyStored() <= 0) continue;
                ElectricalNetwork.sendEnergy(member, be);
            }
        }
    }

    public void transferEnergy(SmartBlockEntity blockEntity) {
        if (blockEntity instanceof IElectric) {
            IElectric be = (IElectric)blockEntity;
            if (!be.outputAllowed()) {
                return;
            }
            CreateTFMG.LOGGER.debug("Started  Transfer");
            for (IElectric member : this.members) {
                if (member.getForgeEnergy() == null || member.equals(be) || member.voltageGeneration() != 0) continue;
                ElectricalNetwork.sendEnergy(be, member);
                if (be.getForgeEnergy().getEnergyStored() != 0) continue;
                return;
            }
        }
    }

    public static int sendEnergy(IElectric sender, IElectric reciever) {
        int maxTransfer1 = sender.getForgeEnergy().extractEnergy(sender.getForgeEnergy().getEnergyStored(), true);
        int maxTransfer2 = reciever.getForgeEnergy().receiveEnergy(sender.getForgeEnergy().getEnergyStored(), true);
        sender.getForgeEnergy().extractEnergy(Math.min(maxTransfer1, maxTransfer2), false);
        return reciever.getForgeEnergy().receiveEnergy(Math.min(maxTransfer1, maxTransfer2), false);
    }

    public void remove(IElectric be) {
        if (!this.members.contains(be)) {
            return;
        }
        this.members.remove(be);
        if (this.members.isEmpty()) {
            ElectricNetworkManager.networks.get(be.getLevel()).remove(this.id);
            return;
        }
    }
}

