/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.createindustry.blocks.electricity.electric_motor;

import com.drmangotea.createindustry.base.util.MaxBlockVoltage;
import com.drmangotea.createindustry.blocks.electricity.base.KineticElectricBlockEntity;
import com.drmangotea.createindustry.registry.TFMGBlockEntities;
import com.drmangotea.createindustry.registry.TFMGBlocks;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.motor.KineticScrollValueBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ElectricMotorBlockEntity
extends KineticElectricBlockEntity
implements IHaveGoggleInformation {
    public static final int DEFAULT_SPEED = 16;
    public static final int MAX_SPEED = 256;
    protected ScrollValueBehaviour generatedSpeed;

    public ElectricMotorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        int max = 256;
        this.generatedSpeed = new KineticScrollValueBehaviour((Component)Lang.translateDirect((String)"kinetics.creative_motor.rotation_speed", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new MotorValueBox());
        this.generatedSpeed.between(-max, max);
        this.generatedSpeed.value = 16;
        this.generatedSpeed.withCallback(i -> this.updateGeneratedRotation());
        this.generatedSpeed.withCallback(i -> this.needsNetworkUpdate());
        behaviours.add((BlockEntityBehaviour)this.generatedSpeed);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.energy.getEnergyStored() > 0 && this.getVoltage() > 0) {
            this.updateGeneratedRotation();
        } else {
            this.sendData();
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.getOrCreateElectricNetwork().requestEnergy((SmartBlockEntity)this);
    }

    @Override
    public void setVoltage(int value, boolean update) {
        super.setVoltage(value, update);
        this.updateGeneratedRotation();
    }

    public float getGeneratedSpeed() {
        if (this.voltage == 0) {
            return 0.0f;
        }
        if (!TFMGBlocks.ELECTRIC_MOTOR.has(this.m_58900_())) {
            return 0.0f;
        }
        this.energy.extractEnergy((int)Math.abs(this.speed / 4.0f), false);
        if (this.energy.getEnergyStored() == 0) {
            return 0.0f;
        }
        return ElectricMotorBlockEntity.convertToDirection((float)Math.min(this.generatedSpeed.getValue(), this.voltage * 2), (Direction)((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)));
    }

    @Override
    public boolean outputAllowed() {
        return false;
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == ((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)).m_122424_();
    }

    @Override
    public int maxVoltage() {
        return MaxBlockVoltage.MAX_VOLTAGES.get(TFMGBlockEntities.ELECTRIC_MOTOR.get());
    }

    @Override
    public int FECapacity() {
        return 10000;
    }

    class MotorValueBox
    extends ValueBoxTransform.Sided {
        MotorValueBox() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)12.5);
        }

        public Vec3 getLocalOffset(BlockState state) {
            Direction facing = (Direction)state.m_61143_((Property)DirectionalKineticBlock.FACING);
            return super.getLocalOffset(state).m_82549_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(-0.0625));
        }

        public void rotate(BlockState state, PoseStack ms) {
            super.rotate(state, ms);
            Direction facing = (Direction)state.m_61143_((Property)DirectionalKineticBlock.FACING);
            if (facing.m_122434_() == Direction.Axis.Y) {
                return;
            }
            if (this.getSide() != Direction.UP) {
                return;
            }
            TransformStack.cast((PoseStack)ms).rotateZ((double)(-AngleHelper.horizontalAngle((Direction)facing) + 180.0f));
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            Direction facing = (Direction)state.m_61143_((Property)DirectionalKineticBlock.FACING);
            if (facing.m_122434_() != Direction.Axis.Y && direction == Direction.DOWN || direction == Direction.UP) {
                return false;
            }
            return direction.m_122434_() != facing.m_122434_();
        }
    }
}

