/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.createindustry.blocks.electricity.energy_components.transformer;

import com.drmangotea.createindustry.base.util.MaxBlockVoltage;
import com.drmangotea.createindustry.blocks.electricity.base.VoltageAlteringBlockEntity;
import com.drmangotea.createindustry.blocks.electricity.base.cables.ElectricalNetwork;
import com.drmangotea.createindustry.blocks.electricity.base.cables.IElectric;
import com.drmangotea.createindustry.blocks.electricity.energy_components.transformer.CoilBlock;
import com.drmangotea.createindustry.registry.TFMGBlockEntities;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class CoilBlockEntity
extends VoltageAlteringBlockEntity {
    public boolean controller = false;
    public int height = 1;
    public int generation = 0;
    ArrayList<CoilBlockEntity> coils = new ArrayList();

    public CoilBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
    }

    @Override
    public int maxVoltage() {
        return MaxBlockVoltage.MAX_VOLTAGES.get(TFMGBlockEntities.COIL.get());
    }

    @Override
    public void onPlaced() {
        IElectric be;
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_7494_());
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).hasElectricitySlot(Direction.DOWN)) {
            be.needsVoltageUpdate();
        }
        super.onPlaced();
    }

    public void destroy() {
        IElectric be;
        CoilBlockEntity coil2;
        super.destroy();
        for (CoilBlockEntity coil2 : this.coils) {
            if (coil2 == null) {
                return;
            }
            coil2.generation = 0;
            coil2.needsVoltageUpdate();
        }
        coil2 = this.f_58857_.m_7702_(this.m_58899_().m_7494_());
        if (coil2 instanceof IElectric && (be = (IElectric)coil2).hasElectricitySlot(Direction.DOWN)) {
            be.getOrCreateElectricNetwork().updateNetworkVoltage();
            be.needsVoltageUpdate();
        }
        BlockPos pos = this.m_58899_().m_7494_();
        for (int i = 0; i < this.height; ++i) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (blockEntity instanceof CoilBlockEntity) {
                CoilBlockEntity be2 = (CoilBlockEntity)blockEntity;
                if (be2.controller) {
                    be2.needsVoltageUpdate();
                }
            }
            pos = pos.m_7494_();
        }
    }

    @Override
    public int FECapacity() {
        return 10000;
    }

    @Override
    public void tick() {
        super.tick();
        if (!((Boolean)this.m_58900_().m_61143_((Property)CoilBlock.CAN_EXTRACT)).booleanValue()) {
            this.getOrCreateElectricNetwork().requestEnergy(this);
        } else {
            this.coils.forEach(be -> ElectricalNetwork.sendEnergy(be, this));
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.controller = !(this.f_58857_.m_8055_(this.m_58899_().m_7494_()).m_60734_() instanceof CoilBlock);
        BlockPos pos = this.m_58899_().m_7495_();
        int height = 1;
        for (int i = 0; i < 4 && this.f_58857_.m_8055_(pos).m_60734_() instanceof CoilBlock; ++i) {
            ++height;
            pos = pos.m_7495_();
        }
        this.height = height;
        if (((Boolean)this.m_58900_().m_61143_((Property)CoilBlock.CAN_EXTRACT)).booleanValue() && !this.controller) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)CoilBlock.CAN_EXTRACT, (Comparable)Boolean.valueOf(false)), 2);
        }
        if (!((Boolean)this.m_58900_().m_61143_((Property)CoilBlock.CAN_EXTRACT)).booleanValue()) {
            return;
        }
        if (this.getVoltage() != this.voltageGeneration()) {
            this.needsVoltageUpdate();
            this.needsNetworkUpdate();
        }
        this.coils = new ArrayList();
        if (this.controller) {
            for (BlockPos checkedPos : BlockPos.m_121940_((BlockPos)new BlockPos((int)this.reachZone().f_82288_, (int)this.reachZone().f_82289_, (int)this.reachZone().f_82290_), (BlockPos)new BlockPos((int)this.reachZone().f_82291_, (int)this.reachZone().f_82292_, (int)this.reachZone().f_82293_))) {
                BlockEntity blockEntity = this.f_58857_.m_7702_(checkedPos);
                if (!(blockEntity instanceof CoilBlockEntity)) continue;
                CoilBlockEntity be = (CoilBlockEntity)blockEntity;
                if (checkedPos == this.m_58899_() || !be.controller || ((Boolean)be.m_58900_().m_61143_((Property)CoilBlock.CAN_EXTRACT)).booleanValue()) continue;
                this.coils.add((CoilBlockEntity)this.f_58857_.m_7702_(checkedPos));
            }
        }
    }

    @Override
    public int voltageGeneration() {
        if (!((Boolean)this.m_58900_().m_61143_((Property)CoilBlock.CAN_EXTRACT)).booleanValue()) {
            return super.voltageGeneration();
        }
        int maxCoilVoltage = 0;
        for (CoilBlockEntity coil : this.coils) {
            float heightRatio = (float)this.height / (float)coil.height;
            maxCoilVoltage = (int)Math.max((float)maxCoilVoltage, heightRatio * (float)coil.getVoltage());
        }
        return Math.max(super.voltageGeneration(), maxCoilVoltage);
    }

    @Override
    public int getOutputVoltage() {
        return this.generation;
    }

    public AABB reachZone() {
        AABB reach = new AABB(this.m_58899_()).m_82400_((double)this.height / 2.0);
        return reach;
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == Direction.UP;
    }
}

