/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.createindustry.blocks.electricity.storage;

import com.drmangotea.createindustry.base.util.MaxBlockVoltage;
import com.drmangotea.createindustry.blocks.electricity.base.ElectricBlockEntity;
import com.drmangotea.createindustry.registry.TFMGBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CapacitorBlockEntity
extends ElectricBlockEntity {
    public int lastVoltage = 0;

    public CapacitorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.getOrCreateElectricNetwork().requestEnergy(this);
    }

    @Override
    public int maxVoltage() {
        return MaxBlockVoltage.MAX_VOLTAGES.get(TFMGBlockEntities.CAPACITOR.get());
    }

    @Override
    public int voltageGeneration() {
        if (this.energy.getEnergyStored() == 0) {
            return 0;
        }
        return this.getVoltage();
    }

    @Override
    public int FECapacity() {
        return 75000;
    }

    @Override
    public int FETransferSpeed() {
        return 1000;
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_) || direction == ((Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_)).m_122424_();
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("LastVoltage", this.lastVoltage);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.lastVoltage = compound.m_128451_("LastVoltage");
    }
}

