/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.createindustry.blocks.engines.diesel;

import com.drmangotea.createindustry.blocks.engines.diesel.DieselEngineBlockEntity;
import com.drmangotea.createindustry.registry.TFMGBlockEntities;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.content.kinetics.steamEngine.PoweredShaftBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PlacementOffset;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Couple;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DieselEngineBlock
extends HorizontalDirectionalBlock
implements IWrenchable,
IBE<DieselEngineBlockEntity> {
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.f_61376_;
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public DieselEngineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(FACE, (Comparable)AttachFace.FLOOR)).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public static Direction getConnectedDirection(BlockState p_53201_) {
        switch ((AttachFace)p_53201_.m_61143_(FACE)) {
            case CEILING: {
                return Direction.DOWN;
            }
            case FLOOR: {
                return Direction.UP;
            }
        }
        return (Direction)p_53201_.m_61143_((Property)f_54117_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{FACE, f_54117_, BlockStateProperties.f_61362_}));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_53184_) {
        for (Direction direction : p_53184_.m_6232_()) {
            BlockState blockstate = direction.m_122434_() == Direction.Axis.Y ? (BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).m_61124_((Property)f_54117_, (Comparable)p_53184_.m_8125_()) : (BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)AttachFace.WALL)).m_61124_((Property)f_54117_, (Comparable)direction.m_122424_());
            if (!blockstate.m_60710_((LevelReader)p_53184_.m_43725_(), p_53184_.m_8083_())) continue;
            return blockstate;
        }
        return null;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        ItemStack heldItem = player.m_21120_(hand);
        IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
        if (placementHelper.matchesItem(heldItem)) {
            return placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
        }
        return InteractionResult.PASS;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighbourState, LevelAccessor world, BlockPos pos, BlockPos neighbourPos) {
        return state;
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        BlockPos shaftPos = DieselEngineBlock.getShaftPos(pState, pPos);
        BlockState shaftState = pLevel.m_8055_(shaftPos);
        if (DieselEngineBlock.isShaftValid(pState, shaftState)) {
            pLevel.m_7731_(shaftPos, PoweredShaftBlock.getEquivalent((BlockState)shaftState), 3);
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!(!pState.m_155947_() || pState.m_60713_(pNewState.m_60734_()) && pNewState.m_155947_())) {
            pLevel.m_46747_(pPos);
        }
        FluidTankBlock.updateBoilerState((BlockState)pState, (Level)pLevel, (BlockPos)pPos.m_121945_(DieselEngineBlock.getFacing(pState).m_122424_()));
        BlockPos shaftPos = DieselEngineBlock.getShaftPos(pState, pPos);
        BlockState shaftState = pLevel.m_8055_(shaftPos);
        if (AllBlocks.POWERED_SHAFT.has(shaftState)) {
            pLevel.m_186460_(shaftPos, shaftState.m_60734_(), 1);
        }
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        AttachFace face = (AttachFace)pState.m_61143_(FACE);
        Direction direction = (Direction)pState.m_61143_((Property)f_54117_);
        return face == AttachFace.CEILING ? AllShapes.STEAM_ENGINE_CEILING.get(direction.m_122434_()) : (face == AttachFace.FLOOR ? AllShapes.STEAM_ENGINE.get(direction.m_122434_()) : AllShapes.STEAM_ENGINE_WALL.get(direction));
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    public static Direction getFacing(BlockState sideState) {
        return DieselEngineBlock.getConnectedDirection(sideState);
    }

    public static BlockPos getShaftPos(BlockState sideState, BlockPos pos) {
        return pos.m_5484_(DieselEngineBlock.getConnectedDirection(sideState), 2);
    }

    public static boolean isShaftValid(BlockState state, BlockState shaft) {
        return (AllBlocks.SHAFT.has(shaft) || AllBlocks.POWERED_SHAFT.has(shaft)) && shaft.m_61143_((Property)ShaftBlock.AXIS) != DieselEngineBlock.getFacing(state).m_122434_();
    }

    public Class<DieselEngineBlockEntity> getBlockEntityClass() {
        return DieselEngineBlockEntity.class;
    }

    public BlockEntityType<? extends DieselEngineBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.DIESEL_ENGINE.get();
    }

    public static Couple<Integer> getSpeedRange() {
        return Couple.create((Object)16, (Object)128);
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> ((BlockEntry)AllBlocks.SHAFT).isIn(arg_0);
        }

        public Predicate<BlockState> getStatePredicate() {
            return s -> s.m_60734_() instanceof DieselEngineBlock;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction direction;
            BlockPos shaftPos = DieselEngineBlock.getShaftPos(state, pos);
            BlockState shaft = AllBlocks.SHAFT.getDefaultState();
            Direction[] directionArray = Direction.m_122382_((Entity)player);
            int n = directionArray.length;
            for (int i = 0; i < n && !DieselEngineBlock.isShaftValid(state, shaft = (BlockState)shaft.m_61124_((Property)ShaftBlock.AXIS, (Comparable)(direction = directionArray[i]).m_122434_())); ++i) {
            }
            BlockState newState = world.m_8055_(shaftPos);
            if (!newState.m_60767_().m_76336_()) {
                return PlacementOffset.fail();
            }
            Direction.Axis axis = (Direction.Axis)shaft.m_61143_((Property)ShaftBlock.AXIS);
            return PlacementOffset.success((Vec3i)shaftPos, s -> (BlockState)BlockHelper.copyProperties((BlockState)s, (BlockState)AllBlocks.POWERED_SHAFT.getDefaultState()).m_61124_((Property)PoweredShaftBlock.AXIS, (Comparable)axis));
        }
    }
}

