/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.createindustry.blocks.engines.small;

import com.drmangotea.createindustry.registry.TFMGFluids;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class EngineBackBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public int consumptionTimer = 0;
    protected LazyOptional<IFluidHandler> fluidCapability;
    public FluidTank tankInventory = this.createInventory();
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;

    public EngineBackBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidCapability = LazyOptional.of(() -> this.tankInventory);
        this.refreshCapability();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        LangBuilder mb = Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        Lang.translate((String)"goggles.engine_exhaust_stats", (Object[])new Object[0]).forGoggles(tooltip);
        LazyOptional handler = this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        Optional resolve = handler.resolve();
        if (!resolve.isPresent()) {
            return false;
        }
        IFluidHandler tank = (IFluidHandler)resolve.get();
        if (tank.getTanks() == 0) {
            return false;
        }
        Lang.translate((String)"goggles.pumpjack_fluid_storage", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        boolean isEmpty = true;
        for (int i = 0; i < tank.getTanks(); ++i) {
            FluidStack fluidStack = tank.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            Lang.fluidName((FluidStack)fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            Lang.builder().add(Lang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(Lang.number((double)tank.getTankCapacity(i)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (tank.getTanks() > 1) {
            if (isEmpty) {
                tooltip.remove(tooltip.size() - 1);
            }
            return true;
        }
        if (!isEmpty) {
            return true;
        }
        Lang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).add(Lang.number((double)tank.getTankCapacity(0)).add(mb).style(ChatFormatting.GOLD)).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
        return true;
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(1000, this::onFluidStackChanged){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().m_6212_((Fluid)TFMGFluids.CARBON_DIOXIDE.getSource());
            }
        };
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        this.sendData();
    }

    public BlockEntity getFrontPart() {
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_);
        if (direction == Direction.UP) {
            return this.f_58857_.m_7702_(this.m_58899_().m_7494_());
        }
        if (direction == Direction.DOWN) {
            return this.f_58857_.m_7702_(this.m_58899_().m_7495_());
        }
        if (direction == Direction.NORTH) {
            return this.f_58857_.m_7702_(this.m_58899_().m_122012_());
        }
        if (direction == Direction.SOUTH) {
            return this.f_58857_.m_7702_(this.m_58899_().m_122019_());
        }
        if (direction == Direction.WEST) {
            return this.f_58857_.m_7702_(this.m_58899_().m_122024_());
        }
        if (direction == Direction.EAST) {
            return this.f_58857_.m_7702_(this.m_58899_().m_122029_());
        }
        return this;
    }

    public void tick() {
        super.tick();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
    }

    public void initialize() {
        super.initialize();
        this.sendData();
        if (this.f_58857_.f_46443_) {
            this.invalidateRenderBoundingBox();
        }
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    private void refreshCapability() {
        LazyOptional<IFluidHandler> oldCap = this.fluidCapability;
        this.fluidCapability = LazyOptional.of(() -> this.handlerForCapability());
        oldCap.invalidate();
    }

    private IFluidHandler handlerForCapability() {
        return this.tankInventory;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.tankInventory.setCapacity(500);
        this.tankInventory.readFromNBT(compound.m_128469_("TankContent"));
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128365_("TankContent", (Tag)this.tankInventory.writeToNBT(new CompoundTag()));
        super.write(compound, clientPacket);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.fluidCapability.isPresent()) {
            this.refreshCapability();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public IFluidTank getTankInventory() {
        return this.tankInventory;
    }
}

