/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.createindustry.blocks.fluids;

import com.mojang.math.Vector3f;
import com.simibubi.create.AllFluids;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.utility.Color;
import com.tterrag.registrate.builders.FluidBuilder;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;

public class AcidFluidType
extends AllFluids.TintedFluidType {
    public static DamageSource damageSourceAcid = new DamageSource("createindustry.acid");
    private Vector3f fogColor;
    private Supplier<Float> fogDistance;

    public AcidFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        super(properties, stillTexture, flowingTexture);
    }

    public static FluidBuilder.FluidTypeFactory create(int fogColor, Supplier<Float> fogDistance) {
        return (p, s, f) -> {
            AcidFluidType fluidType = new AcidFluidType(p, s, f);
            fluidType.fogColor = new Color(fogColor, false).asVectorF();
            fluidType.fogDistance = fogDistance;
            return fluidType;
        };
    }

    protected Vector3f getCustomFogColor() {
        return this.fogColor;
    }

    protected float getFogDistanceModifier() {
        return this.fogDistance.get().floatValue();
    }

    protected int getTintColor(FluidStack stack) {
        return -1;
    }

    public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
        return 0xFFFFFF;
    }

    public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
        if (Create.RANDOM.nextInt(2) == 0) {
            entity.m_6469_(damageSourceAcid, 2.0f);
        }
        return false;
    }
}

