/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.createindustry.blocks.tanks;

import com.drmangotea.createindustry.blocks.tanks.SteelTankBlock;
import com.drmangotea.createindustry.blocks.tanks.SteelTankBlockEntity;
import com.drmangotea.createindustry.registry.TFMGBlockEntities;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;

public class SteelTankItem
extends BlockItem {
    public SteelTankItem(Block p_i48527_1_, Item.Properties p_i48527_2_) {
        super(p_i48527_1_, p_i48527_2_);
    }

    public InteractionResult m_40576_(BlockPlaceContext ctx) {
        InteractionResult initialResult = super.m_40576_(ctx);
        if (!initialResult.m_19077_()) {
            return initialResult;
        }
        this.tryMultiPlace(ctx);
        return initialResult;
    }

    protected boolean m_7274_(BlockPos p_195943_1_, Level p_195943_2_, Player p_195943_3_, ItemStack p_195943_4_, BlockState p_195943_5_) {
        MinecraftServer minecraftserver = p_195943_2_.m_7654_();
        if (minecraftserver == null) {
            return false;
        }
        CompoundTag nbt = p_195943_4_.m_41737_("BlockEntityTag");
        if (nbt != null) {
            FluidStack fluid;
            nbt.m_128473_("Luminosity");
            nbt.m_128473_("Size");
            nbt.m_128473_("Height");
            nbt.m_128473_("Controller");
            nbt.m_128473_("LastKnownPos");
            if (nbt.m_128441_("TankContent") && !(fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("TankContent"))).isEmpty()) {
                fluid.setAmount(Math.min(SteelTankBlockEntity.getCapacityMultiplier(), fluid.getAmount()));
                nbt.m_128365_("TankContent", (Tag)fluid.writeToNBT(new CompoundTag()));
            }
        }
        return super.m_7274_(p_195943_1_, p_195943_2_, p_195943_3_, p_195943_4_, p_195943_5_);
    }

    private void tryMultiPlace(BlockPlaceContext ctx) {
        BlockState blockState;
        BlockPos offsetPos;
        int zOffset;
        int xOffset;
        BlockPos startPos;
        BlockPos pos;
        BlockPos placedOnPos;
        Player player = ctx.m_43723_();
        if (player == null) {
            return;
        }
        if (player.m_6144_()) {
            return;
        }
        Direction face = ctx.m_43719_();
        if (!face.m_122434_().m_122478_()) {
            return;
        }
        ItemStack stack = ctx.m_43722_();
        Level world = ctx.m_43725_();
        BlockState placedOnState = world.m_8055_(placedOnPos = (pos = ctx.m_8083_()).m_121945_(face.m_122424_()));
        if (!SteelTankBlock.isTank(placedOnState)) {
            return;
        }
        SteelTankBlockEntity tankAt = (SteelTankBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)TFMGBlockEntities.STEEL_FLUID_TANK.get()), (BlockGetter)world, (BlockPos)placedOnPos);
        if (tankAt == null) {
            return;
        }
        SteelTankBlockEntity controllerTE = tankAt.getControllerBE();
        if (controllerTE == null) {
            return;
        }
        int width = controllerTE.width;
        if (width == 1) {
            return;
        }
        int tanksToPlace = 0;
        BlockPos blockPos = startPos = face == Direction.DOWN ? controllerTE.m_58899_().m_7495_() : controllerTE.m_58899_().m_6630_(controllerTE.height);
        if (startPos.m_123342_() != pos.m_123342_()) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = startPos.m_7918_(xOffset, 0, zOffset);
                blockState = world.m_8055_(offsetPos);
                if (SteelTankBlock.isTank(blockState)) continue;
                if (!blockState.m_60767_().m_76336_()) {
                    return;
                }
                ++tanksToPlace;
            }
        }
        if (!player.m_7500_() && stack.m_41613_() < tanksToPlace) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = startPos.m_7918_(xOffset, 0, zOffset);
                blockState = world.m_8055_(offsetPos);
                if (SteelTankBlock.isTank(blockState)) continue;
                BlockPlaceContext context = BlockPlaceContext.m_43644_((BlockPlaceContext)ctx, (BlockPos)offsetPos, (Direction)face);
                player.getPersistentData().m_128379_("SilenceTankSound", true);
                super.m_40576_(context);
                player.getPersistentData().m_128473_("SilenceTankSound");
            }
        }
    }
}

