/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.UV;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageScreen;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;

public class LimitedBarrelScreen
extends StorageScreen {
    public static final ResourceLocation GUI_BACKGROUNDS = SophisticatedStorage.getRL("textures/gui/limited_barrels.png");
    public static final TextureBlitData LIMITED_I_BACKGROUND = new TextureBlitData(GUI_BACKGROUNDS, Dimension.SQUARE_256, new UV(0, 0), new Dimension(84, 82));
    public static final TextureBlitData LIMITED_II_BACKGROUND = new TextureBlitData(GUI_BACKGROUNDS, Dimension.SQUARE_256, new UV(84, 0), new Dimension(84, 82));
    public static final TextureBlitData LIMITED_III_BACKGROUND = new TextureBlitData(GUI_BACKGROUNDS, Dimension.SQUARE_256, new UV(0, 82), new Dimension(84, 82));
    public static final TextureBlitData LIMITED_IV_BACKGROUND = new TextureBlitData(GUI_BACKGROUNDS, Dimension.SQUARE_256, new UV(84, 82), new Dimension(84, 82));
    public static final TextureBlitData SMALL_BAR_FILL = new TextureBlitData(GUI_BACKGROUNDS, Dimension.SQUARE_256, new UV(171, 0), new Dimension(3, 28));
    public static final TextureBlitData LARGE_BAR_FILL = new TextureBlitData(GUI_BACKGROUNDS, Dimension.SQUARE_256, new UV(168, 0), new Dimension(3, 68));
    public static final int STORAGE_SLOTS_HEIGHT = 82;
    private static final int MIDDLE_OF_STORAGE_SLOTS = 59;

    public LimitedBarrelScreen(StorageContainerMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    protected void drawSlotBg(PoseStack matrixStack, int x, int y) {
        LimitedBarrelScreen.drawSlotBg(this, matrixStack, x, y, ((StorageContainerMenu)this.m_6262_()).getNumberOfStorageInventorySlots());
    }

    public static void drawSlotBg(AbstractContainerScreen<?> screen, PoseStack matrixStack, int x, int y, int slotsNumber) {
        TextureBlitData backgroundTexture = LimitedBarrelScreen.getBackgroundTexture(slotsNumber);
        GuiHelper.blit((PoseStack)matrixStack, (int)(x + screen.getXSize() / 2 - backgroundTexture.getWidth() / 2 - 1), (int)(y + 17), (TextureBlitData)backgroundTexture);
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        super.m_7027_(poseStack, mouseX, mouseY);
        switch (((StorageContainerMenu)this.m_6262_()).getNumberOfStorageInventorySlots()) {
            case 1: {
                this.renderBar(poseStack, this.f_97726_ / 2 + 37, 24, ((StorageContainerMenu)this.m_6262_()).getSlotFillPercentage(0), LARGE_BAR_FILL, false);
                break;
            }
            case 2: {
                this.renderBar(poseStack, this.f_97726_ / 2 + 37, 24, ((StorageContainerMenu)this.m_6262_()).getSlotFillPercentage(0), SMALL_BAR_FILL, false);
                this.renderBar(poseStack, this.f_97726_ / 2 + 37, 64, ((StorageContainerMenu)this.m_6262_()).getSlotFillPercentage(1), SMALL_BAR_FILL, false);
                break;
            }
            case 3: {
                this.renderBar(poseStack, this.f_97726_ / 2 + 37, 24, ((StorageContainerMenu)this.m_6262_()).getSlotFillPercentage(0), SMALL_BAR_FILL, false);
                this.renderBar(poseStack, this.f_97726_ / 2 - 37 - 5, 64, ((StorageContainerMenu)this.m_6262_()).getSlotFillPercentage(1), SMALL_BAR_FILL, true);
                this.renderBar(poseStack, this.f_97726_ / 2 + 37, 64, ((StorageContainerMenu)this.m_6262_()).getSlotFillPercentage(2), SMALL_BAR_FILL, false);
                break;
            }
            case 4: {
                this.renderBar(poseStack, this.f_97726_ / 2 - 37 - 5, 24, ((StorageContainerMenu)this.m_6262_()).getSlotFillPercentage(0), SMALL_BAR_FILL, true);
                this.renderBar(poseStack, this.f_97726_ / 2 + 37, 24, ((StorageContainerMenu)this.m_6262_()).getSlotFillPercentage(1), SMALL_BAR_FILL, false);
                this.renderBar(poseStack, this.f_97726_ / 2 - 37 - 5, 64, ((StorageContainerMenu)this.m_6262_()).getSlotFillPercentage(2), SMALL_BAR_FILL, true);
                this.renderBar(poseStack, this.f_97726_ / 2 + 37, 64, ((StorageContainerMenu)this.m_6262_()).getSlotFillPercentage(3), SMALL_BAR_FILL, false);
            }
        }
    }

    private static TextureBlitData getBackgroundTexture(int slotsNumber) {
        return switch (slotsNumber) {
            case 1 -> LIMITED_I_BACKGROUND;
            case 2 -> LIMITED_II_BACKGROUND;
            case 3 -> LIMITED_III_BACKGROUND;
            case 4 -> LIMITED_IV_BACKGROUND;
            default -> throw new IllegalStateException("Unexpected number of limited barrel slots: " + slotsNumber);
        };
    }

    protected int getStorageInventoryHeight(int displayableNumberOfRows) {
        return 82;
    }

    protected void updateStorageSlotsPositions() {
        LimitedBarrelScreen.updateSlotPositions(this.m_6262_(), ((StorageContainerMenu)this.m_6262_()).getNumberOfStorageInventorySlots(), this.f_97726_);
    }

    public static void updateSlotPositions(AbstractContainerMenu menu, int slotNumber, int imageWidth) {
        int halfWidth = imageWidth / 2;
        if (slotNumber == 1) {
            Slot slot = menu.m_38853_(0);
            slot.f_40220_ = halfWidth - 9;
            slot.f_40221_ = 50;
        } else if (slotNumber == 2) {
            Slot slot = menu.m_38853_(0);
            slot.f_40220_ = halfWidth - 9;
            slot.f_40221_ = 30;
            slot = menu.m_38853_(1);
            slot.f_40220_ = halfWidth - 9;
            slot.f_40221_ = 70;
        } else if (slotNumber == 3) {
            Slot slot = menu.m_38853_(0);
            slot.f_40220_ = halfWidth - 9;
            slot.f_40221_ = 30;
            slot = menu.m_38853_(1);
            slot.f_40220_ = halfWidth - 29;
            slot.f_40221_ = 70;
            slot = menu.m_38853_(2);
            slot.f_40220_ = halfWidth + 11;
            slot.f_40221_ = 70;
        } else if (slotNumber == 4) {
            Slot slot = menu.m_38853_(0);
            slot.f_40220_ = halfWidth - 29;
            slot.f_40221_ = 30;
            slot = menu.m_38853_(1);
            slot.f_40220_ = halfWidth + 11;
            slot.f_40221_ = 30;
            slot = menu.m_38853_(2);
            slot.f_40220_ = halfWidth - 29;
            slot.f_40221_ = 70;
            slot = menu.m_38853_(3);
            slot.f_40220_ = halfWidth + 11;
            slot.f_40221_ = 70;
        }
    }

    private void renderBar(PoseStack poseStack, int x, int y, float percentage, TextureBlitData barTexture, boolean left) {
        int barHeight = (int)((float)barTexture.getHeight() * percentage);
        int yOffset = barTexture.getHeight() - barHeight;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)barTexture.getTextureName());
        GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)(y + yOffset), (float)barTexture.getU(), (float)(barTexture.getV() + yOffset), (int)barTexture.getWidth(), (int)barHeight, (int)barTexture.getTextureWidth(), (int)barTexture.getTextureHeight());
        String text = String.valueOf((int)(percentage * 100.0f)) + "%";
        int percentageX = x;
        percentageX = left ? (percentageX -= 2 + this.f_96541_.f_91062_.m_92895_(text)) : (percentageX += 6);
        this.f_96541_.f_91062_.m_92883_(poseStack, text, (float)percentageX, (float)(y + barTexture.getHeight() / 2 - 3), 0x2C2C2C);
    }

    protected boolean shouldShowSortButtons() {
        return false;
    }
}

