/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.config;

import java.nio.file.Path;
import java.util.Comparator;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.core.config.sorting.MappedSortingConfig;
import mezz.jei.core.config.sorting.serializers.SortingSerializers;

public class RecipeCategorySortingConfig
extends MappedSortingConfig<RecipeType<?>, String> {
    public RecipeCategorySortingConfig(Path path) {
        super(path, SortingSerializers.STRING, r -> r.getUid().toString());
    }

    @Override
    protected Comparator<String> getDefaultSortOrder() {
        Comparator<String> minecraftCraftingFirst = Comparator.comparing(s -> {
            String vanillaCrafting = RecipeTypes.CRAFTING.getUid().toString();
            return s.equals(vanillaCrafting);
        }).reversed();
        Comparator<String> minecraftFirst = Comparator.comparing(s -> s.startsWith("minecraft")).reversed();
        Comparator naturalOrder = Comparator.naturalOrder();
        return minecraftCraftingFirst.thenComparing(minecraftFirst).thenComparing(naturalOrder);
    }
}

