/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.piston.MechanicalPistonBlock;
import com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.BlockHitResult;
import rbasamoyai.createbigcannons.CBCTags;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesHandler;
import rbasamoyai.createbigcannons.block_hit_effects.BlockImpactTransformationHandler;
import rbasamoyai.createbigcannons.cannon_control.config.CannonMountPropertiesHandler;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.cannon_loading.CannonLoaderBlock;
import rbasamoyai.createbigcannons.cannon_loading.CannonLoaderBlockEntity;
import rbasamoyai.createbigcannons.cannons.autocannon.material.AutocannonMaterialPropertiesHandler;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBehavior;
import rbasamoyai.createbigcannons.cannons.big_cannons.IBigCannonBlockEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.breeches.BigCannonBreechStrengthHandler;
import rbasamoyai.createbigcannons.cannons.big_cannons.material.BigCannonMaterialPropertiesHandler;
import rbasamoyai.createbigcannons.crafting.BlockRecipeFinder;
import rbasamoyai.createbigcannons.crafting.BlockRecipesManager;
import rbasamoyai.createbigcannons.crafting.boring.AbstractCannonDrillBlockEntity;
import rbasamoyai.createbigcannons.crafting.boring.CannonDrillBlock;
import rbasamoyai.createbigcannons.crafting.builtup.CannonBuilderBlock;
import rbasamoyai.createbigcannons.crafting.builtup.CannonBuilderBlockEntity;
import rbasamoyai.createbigcannons.crafting.casting.FluidCastingTimeHandler;
import rbasamoyai.createbigcannons.crafting.munition_assembly.AutocannonAmmoContainerFillingDeployerRecipe;
import rbasamoyai.createbigcannons.crafting.munition_assembly.BigCartridgeFillingDeployerRecipe;
import rbasamoyai.createbigcannons.crafting.munition_assembly.CartridgeAssemblyDeployerRecipe;
import rbasamoyai.createbigcannons.crafting.munition_assembly.MunitionFuzingDeployerRecipe;
import rbasamoyai.createbigcannons.crafting.munition_assembly.TracerApplicationDeployerRecipe;
import rbasamoyai.createbigcannons.crafting.welding.CannonWelderItem;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.index.CBCItems;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.munitions.autocannon.AutocannonRoundItem;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCartridgeBlockItem;
import rbasamoyai.createbigcannons.munitions.config.BigCannonPropellantCompatibilityHandler;
import rbasamoyai.createbigcannons.munitions.config.DimensionMunitionPropertiesHandler;
import rbasamoyai.createbigcannons.munitions.config.FluidDragHandler;
import rbasamoyai.createbigcannons.munitions.config.MunitionPropertiesHandler;
import rbasamoyai.createbigcannons.network.CBCRootNetwork;
import rbasamoyai.createbigcannons.network.ClientboundNotifyTagReloadPacket;
import rbasamoyai.createbigcannons.remix.ContraptionRemix;

public class CBCCommonEvents {
    public static void serverLevelTickEnd(Level level) {
        CreateBigCannons.BLOCK_DAMAGE.tick(level);
    }

    public static void onPlayerLogin(ServerPlayer player) {
        CBCRootNetwork.onPlayerJoin(player);
        CreateBigCannons.BLOCK_DAMAGE.playerLogin((Player)player);
    }

    public static void onPlayerLogout(Player player) {
        CreateBigCannons.BLOCK_DAMAGE.playerLogout(player);
    }

    public static boolean onPlayerBreakBlock(BlockState state, LevelAccessor level, BlockPos pos, Player player) {
        PitchOrientedContraptionEntity poce;
        Entity entity = player.m_20202_();
        if (entity instanceof PitchOrientedContraptionEntity && (poce = (PitchOrientedContraptionEntity)entity).getSeatPos((Entity)player) != null) {
            return true;
        }
        if (AllBlocks.PISTON_EXTENSION_POLE.has(state = ContraptionRemix.getInnerCannonState(level, state, pos, null))) {
            Level llevel;
            BlockPos drillPos = CBCCommonEvents.destroyPoleContraption((Block)CBCBlocks.CANNON_DRILL_BIT.get(), (Block)CBCBlocks.CANNON_DRILL.get(), CannonDrillBlock.maxAllowedDrillLength(), state, level, pos, player);
            if (drillPos != null) {
                level.m_7731_(drillPos, (BlockState)level.m_8055_(drillPos).m_61124_(CannonDrillBlock.STATE, (Comparable)MechanicalPistonBlock.PistonState.RETRACTED), 3);
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof AbstractCannonDrillBlockEntity) {
                    AbstractCannonDrillBlockEntity drill = (AbstractCannonDrillBlockEntity)blockEntity;
                    drill.onLengthBroken();
                }
                return false;
            }
            BlockPos builderPos = CBCCommonEvents.destroyPoleContraption((Block)CBCBlocks.CANNON_BUILDER_HEAD.get(), (Block)CBCBlocks.CANNON_BUILDER.get(), CannonBuilderBlock.maxAllowedBuilderLength(), state, level, pos, player);
            if (builderPos != null) {
                level.m_7731_(builderPos, (BlockState)level.m_8055_(builderPos).m_61124_(CannonBuilderBlock.STATE, (Comparable)((Object)CannonBuilderBlock.BuilderState.UNACTIVATED)), 3);
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof CannonBuilderBlockEntity) {
                    CannonBuilderBlockEntity builder = (CannonBuilderBlockEntity)blockEntity;
                    builder.onLengthBroken();
                }
            }
            if (level instanceof Level && CBCCommonEvents.destroyCannonLoader(state, llevel = (Level)level, pos, player)) {
                return true;
            }
        }
        return false;
    }

    private static BlockPos destroyPoleContraption(Block head, Block base, int limit, BlockState state, LevelAccessor level, BlockPos pos, Player player) {
        Direction.Axis axis = ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_();
        Direction positive = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        BlockPos headPos = null;
        BlockPos basePos = null;
        int[] nArray = new int[]{1, -1};
        int n = nArray.length;
        block0: for (int i = 0; i < n; ++i) {
            int mod;
            int offs = mod = nArray[i];
            while (mod * offs < limit) {
                BlockPos pos1 = pos.m_5484_(positive, offs);
                BlockState state1 = level.m_8055_(pos1);
                if (!AllBlocks.PISTON_EXTENSION_POLE.has(state1) || axis != ((Direction)state1.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_()) {
                    if (state1.m_60713_(head) && axis == ((Direction)state1.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_()) {
                        headPos = pos1;
                    }
                    if (!state1.m_60713_(base) || axis != ((Direction)state1.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_()) continue block0;
                    basePos = pos1;
                    continue block0;
                }
                offs += mod;
            }
        }
        if (headPos == null || basePos == null) {
            return null;
        }
        BlockPos baseCopy = basePos.m_7949_();
        BlockPos.m_121990_(headPos, basePos).filter(p -> !p.equals((Object)pos) && !p.equals((Object)baseCopy)).forEach(p -> level.m_46961_(p, !player.m_7500_()));
        return baseCopy;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean destroyCannonLoader(BlockState state, Level level, BlockPos pos, Player player) {
        Direction.Axis axis = ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_();
        Direction positive = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        Direction dirFinal = null;
        BlockPos headPos = null;
        BlockState headState = null;
        BlockPos basePos = null;
        int LIMIT = CannonLoaderBlock.maxAllowedLoaderLength();
        int[] nArray = new int[]{1, -1};
        int n = nArray.length;
        block0: for (int i = 0; i < n; ++i) {
            int mod;
            int offs = mod = nArray[i];
            while (mod * offs < LIMIT) {
                BlockPos pos1 = pos.m_5484_(positive, offs);
                BlockState currentState = ContraptionRemix.getInnerCannonState((LevelAccessor)level, level.m_8055_(pos1), pos1, positive);
                if (AllBlocks.PISTON_EXTENSION_POLE.has(currentState) && axis == ((Direction)currentState.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_()) {
                    offs += mod;
                    continue;
                }
                if (CannonLoaderBlock.isLoaderHead(currentState) && axis == ((Direction)currentState.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_()) {
                    headPos = pos1;
                    headState = currentState;
                }
                if (!CBCBlocks.CANNON_LOADER.has(currentState) || axis != ((Direction)currentState.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_()) continue block0;
                basePos = pos1;
                dirFinal = (Direction)currentState.m_61143_((Property)BlockStateProperties.f_61372_);
                continue block0;
            }
        }
        if (headPos == null) return false;
        if (basePos == null) {
            return false;
        }
        BlockPos baseCopy = basePos.m_7949_();
        BlockPos headCopy = headPos.m_7949_();
        BlockPos.m_121990_(headPos, basePos).filter(p -> !p.equals((Object)pos) && !p.equals((Object)baseCopy)).forEach(p -> {
            boolean drop;
            boolean bl = drop = !player.m_7500_() && !p.equals((Object)headCopy);
            if (!ContraptionRemix.removeCannonContentsOnBreak(level, p, drop)) {
                level.m_46961_(p, drop);
            }
        });
        BlockEntity mod = level.m_7702_(basePos);
        if (mod instanceof CannonLoaderBlockEntity) {
            CannonLoaderBlockEntity loader = (CannonLoaderBlockEntity)mod;
            loader.onLengthBroken();
        }
        BlockPos aheadPos = basePos.m_121945_(dirFinal);
        boolean cancel = pos.equals((Object)aheadPos);
        BlockEntity blockEntity = level.m_7702_(aheadPos);
        if (blockEntity instanceof IBigCannonBlockEntity) {
            IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)blockEntity;
            if (!cancel) {
                ((BigCannonBehavior)((Object)cbe.cannonBehavior())).loadBlock(new StructureTemplate.StructureBlockInfo(BlockPos.f_121853_, headState, null));
                return cancel;
            }
        }
        level.m_7731_(aheadPos, headState, 3);
        return cancel;
    }

    public static void onLoadLevel(LevelAccessor level) {
        CreateBigCannons.BLOCK_DAMAGE.levelLoaded(level);
        if (level.m_7654_() != null && !level.m_5776_() && level.m_7654_().m_129783_() == level) {
            CBCCommonEvents.loadTags();
        }
    }

    public static void loadTags() {
        BlockArmorPropertiesHandler.loadTags();
        FluidCastingTimeHandler.loadTags();
        BlockImpactTransformationHandler.loadTags();
        FluidDragHandler.loadTags();
    }

    public static void onDatapackReload(MinecraftServer server) {
        CBCCommonEvents.loadTags();
        NetworkPlatform.sendToClientAll(new ClientboundNotifyTagReloadPacket(), server);
        BlockArmorPropertiesHandler.syncToAll(server);
        BlockRecipesManager.syncToAll(server);
        MunitionPropertiesHandler.syncToAll(server);
        AutocannonMaterialPropertiesHandler.syncToAll(server);
        BigCannonMaterialPropertiesHandler.syncToAll(server);
        BigCannonBreechStrengthHandler.syncToAll(server);
        FluidCastingTimeHandler.syncToAll(server);
        CannonMountPropertiesHandler.syncToAll(server);
        DimensionMunitionPropertiesHandler.syncToAll(server);
        FluidDragHandler.syncToAll(server);
    }

    public static void onDatapackSync(ServerPlayer player) {
        BlockArmorPropertiesHandler.syncTo(player);
        BlockRecipesManager.syncTo(player);
        MunitionPropertiesHandler.syncTo(player);
        AutocannonMaterialPropertiesHandler.syncTo(player);
        BigCannonMaterialPropertiesHandler.syncTo(player);
        BigCannonBreechStrengthHandler.syncTo(player);
        FluidCastingTimeHandler.syncTo(player);
        BigCannonPropellantCompatibilityHandler.syncTo(player);
        CannonMountPropertiesHandler.syncTo(player);
        DimensionMunitionPropertiesHandler.syncTo(player);
        FluidDragHandler.syncTo(player);
    }

    public static void onAddReloadListeners(BiConsumer<PreparableReloadListener, ResourceLocation> cons) {
        cons.accept((PreparableReloadListener)BlockRecipeFinder.LISTENER, CreateBigCannons.resource("block_recipe_finder"));
        cons.accept((PreparableReloadListener)BlockRecipesManager.ReloadListener.INSTANCE, CreateBigCannons.resource("block_recipe_manager"));
        cons.accept((PreparableReloadListener)BlockArmorPropertiesHandler.BlockReloadListener.INSTANCE, CreateBigCannons.resource("block_hardness_handler"));
        cons.accept((PreparableReloadListener)MunitionPropertiesHandler.ReloadListenerProjectiles.INSTANCE, CreateBigCannons.resource("projectile_properties_handler"));
        cons.accept((PreparableReloadListener)MunitionPropertiesHandler.ReloadListenerBlockPropellant.INSTANCE, CreateBigCannons.resource("block_propellant_properties_handler"));
        cons.accept((PreparableReloadListener)MunitionPropertiesHandler.ReloadListenerItemPropellant.INSTANCE, CreateBigCannons.resource("item_propellant_properties_handler"));
        cons.accept((PreparableReloadListener)DimensionMunitionPropertiesHandler.ReloadListener.INSTANCE, CreateBigCannons.resource("dimension_munition_properties_handler"));
        cons.accept((PreparableReloadListener)AutocannonMaterialPropertiesHandler.ReloadListener.INSTANCE, CreateBigCannons.resource("autocannon_material_properties_handler"));
        cons.accept((PreparableReloadListener)BigCannonMaterialPropertiesHandler.ReloadListener.INSTANCE, CreateBigCannons.resource("big_cannon_material_properties_handler"));
        cons.accept((PreparableReloadListener)BigCannonBreechStrengthHandler.ReloadListener.INSTANCE, CreateBigCannons.resource("big_cannon_breech_strength_handler"));
        cons.accept((PreparableReloadListener)FluidCastingTimeHandler.ReloadListener.INSTANCE, CreateBigCannons.resource("fluid_casting_time_handler"));
        cons.accept((PreparableReloadListener)BigCannonPropellantCompatibilityHandler.ReloadListener.INSTANCE, CreateBigCannons.resource("big_cannon_propellant_compatibility_handler"));
        cons.accept((PreparableReloadListener)CannonMountPropertiesHandler.BlockEntityReloadListener.INSTANCE, CreateBigCannons.resource("block_entity_cannon_mounts_config_handler"));
        cons.accept((PreparableReloadListener)CannonMountPropertiesHandler.EntityReloadListener.INSTANCE, CreateBigCannons.resource("entity_cannon_mounts_config_handler"));
        cons.accept((PreparableReloadListener)BlockImpactTransformationHandler.ReloadListener.INSTANCE, CreateBigCannons.resource("block_impact_transformation_handler"));
        cons.accept((PreparableReloadListener)FluidDragHandler.ReloadListener.INSTANCE, CreateBigCannons.resource("fluid_drag_handler"));
    }

    public static void onAddDeployerRecipes(DeployerBlockEntity deployer, Container container, BiConsumer<Supplier<Optional<? extends Recipe<? extends Container>>>, Integer> cons) {
        AutocannonAmmoContainerFillingDeployerRecipe ammoContainerRecipe;
        TracerApplicationDeployerRecipe tracerRecipe;
        MunitionFuzingDeployerRecipe fuzingRecipe;
        ItemStack containerItem = container.m_8020_(0);
        ItemStack deployerItem = container.m_8020_(1);
        Item item = containerItem.m_41720_();
        if (item instanceof BigCartridgeBlockItem) {
            int power;
            BigCartridgeBlockItem cartridge = (BigCartridgeBlockItem)item;
            if (deployerItem.m_204117_(CBCTags.CBCItemTags.NITROPOWDER) && (power = BigCartridgeBlockItem.getPower(containerItem)) < cartridge.getMaximumPowerLevels()) {
                cons.accept(() -> Optional.of(new BigCartridgeFillingDeployerRecipe(power, power + 1)), 25);
            }
        }
        if (CBCItems.FILLED_AUTOCANNON_CARTRIDGE.isIn(containerItem) && deployerItem.m_41720_() instanceof AutocannonRoundItem) {
            cons.accept(() -> Optional.of(new CartridgeAssemblyDeployerRecipe(deployerItem)), 25);
        }
        if ((fuzingRecipe = new MunitionFuzingDeployerRecipe(containerItem, deployerItem)).m_5818_(container, deployer.m_58904_())) {
            cons.accept(() -> Optional.of(fuzingRecipe), 25);
        }
        if ((tracerRecipe = new TracerApplicationDeployerRecipe(containerItem, deployerItem)).m_5818_(container, deployer.m_58904_())) {
            cons.accept(() -> Optional.of(tracerRecipe), 25);
        }
        if ((ammoContainerRecipe = new AutocannonAmmoContainerFillingDeployerRecipe(containerItem, deployerItem)).m_5818_(container, deployer.m_58904_())) {
            cons.accept(() -> Optional.of(ammoContainerRecipe), 25);
        }
    }

    public static InteractionResult onUseItemOnBlock(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof CannonWelderItem) {
            return CannonWelderItem.welderItemAlwaysPlacesWhenUsed(player, level, hand, hitResult);
        }
        return InteractionResult.PASS;
    }
}

