/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.contraption;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.ContraptionType;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.foundation.utility.Components;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.cannon_control.ControlPitchContraption;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlockEntity;
import rbasamoyai.createbigcannons.cannon_control.cannon_types.CBCCannonContraptionTypes;
import rbasamoyai.createbigcannons.cannon_control.cannon_types.ICannonContraptionType;
import rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.ItemCannon;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.cannons.ItemCannonBehavior;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonBarrelBlock;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonBlock;
import rbasamoyai.createbigcannons.cannons.autocannon.IAutocannonBlockEntity;
import rbasamoyai.createbigcannons.cannons.autocannon.MovesWithAutocannonRecoilSpring;
import rbasamoyai.createbigcannons.cannons.autocannon.breech.AbstractAutocannonBreechBlockEntity;
import rbasamoyai.createbigcannons.cannons.autocannon.breech.AutocannonBreechBlock;
import rbasamoyai.createbigcannons.cannons.autocannon.material.AutocannonMaterial;
import rbasamoyai.createbigcannons.cannons.autocannon.material.AutocannonMaterialProperties;
import rbasamoyai.createbigcannons.cannons.autocannon.recoil_spring.AutocannonRecoilSpringBlock;
import rbasamoyai.createbigcannons.cannons.autocannon.recoil_spring.AutocannonRecoilSpringBlockEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.effects.particles.plumes.AutocannonPlumeParticleData;
import rbasamoyai.createbigcannons.index.CBCAutocannonMaterials;
import rbasamoyai.createbigcannons.index.CBCContraptionTypes;
import rbasamoyai.createbigcannons.index.CBCEntityTypes;
import rbasamoyai.createbigcannons.index.CBCSoundEvents;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.munitions.autocannon.AbstractAutocannonProjectile;
import rbasamoyai.createbigcannons.munitions.autocannon.AutocannonAmmoItem;
import rbasamoyai.createbigcannons.munitions.autocannon.AutocannonAmmoType;
import rbasamoyai.createbigcannons.munitions.autocannon.config.AutocannonProjectilePropertiesComponent;
import rbasamoyai.createbigcannons.network.ClientboundAnimateCannonContraptionPacket;
import rbasamoyai.createbigcannons.utils.CBCUtils;
import rbasamoyai.ritchiesprojectilelib.RitchiesProjectileLib;

public class MountedAutocannonContraption
extends AbstractMountedCannonContraption
implements ItemCannon {
    private AutocannonMaterial cannonMaterial;
    private final Set<BlockPos> recoilSpringPositions = new LinkedHashSet<BlockPos>();
    private boolean isHandle = false;

    public boolean assemble(Level level, BlockPos pos) throws AssemblyException {
        if (!this.collectCannonBlocks(level, pos)) {
            return false;
        }
        this.bounds = this.createBoundsFromExtensionLengths();
        return !this.blocks.isEmpty();
    }

    private boolean collectCannonBlocks(Level level, BlockPos pos) throws AssemblyException {
        BlockPos mainRecoilSpringPos;
        Object v;
        AutocannonRecoilSpringBlock springBlock;
        StructureTemplate.StructureBlockInfo possibleSpring;
        StructureTemplate.StructureBlockInfo localBlockInfo;
        BlockPos negativeEndPos;
        Block block;
        Block block2;
        BlockState startState = level.m_8055_(pos);
        Block block3 = startState.m_60734_();
        if (!(block3 instanceof AutocannonBlock)) {
            return false;
        }
        AutocannonBlock startCannon = (AutocannonBlock)block3;
        if (!startCannon.isComplete(startState)) {
            throw MountedAutocannonContraption.hasIncompleteCannonBlocks(pos);
        }
        AutocannonMaterial material = startCannon.getAutocannonMaterial();
        boolean isStartBreech = startCannon.isBreechMechanism(startState);
        ArrayList<StructureTemplate.StructureBlockInfo> cannonBlocks = new ArrayList<StructureTemplate.StructureBlockInfo>();
        cannonBlocks.add(new StructureTemplate.StructureBlockInfo(pos, startState, this.getBlockEntityNBT(level, pos)));
        int cannonLength = 1;
        Direction cannonFacing = startCannon.getFacing(startState);
        Direction positive = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)cannonFacing.m_122434_());
        Direction negative = positive.m_122424_();
        BlockPos start = pos;
        BlockState nextState = level.m_8055_(pos.m_121945_(positive));
        boolean positiveBreech = false;
        while ((block2 = nextState.m_60734_()) instanceof AutocannonBlock) {
            AutocannonBlock cBlock = (AutocannonBlock)block2;
            if (!this.isConnectedToCannon((LevelAccessor)level, nextState, start.m_121945_(positive), positive, material)) break;
            start = start.m_121945_(positive);
            if (!cBlock.isComplete(nextState)) {
                throw MountedAutocannonContraption.hasIncompleteCannonBlocks(start);
            }
            cannonBlocks.add(new StructureTemplate.StructureBlockInfo(start, nextState, this.getBlockEntityNBT(level, start)));
            ++this.frontExtensionLength;
            ++cannonLength;
            positiveBreech = cBlock.isBreechMechanism(nextState);
            if (positiveBreech && isStartBreech) {
                throw MountedAutocannonContraption.invalidCannon();
            }
            if (positiveBreech && cBlock.getFacing(nextState) != negative) {
                throw MountedAutocannonContraption.incorrectBreechDirection(start);
            }
            nextState = level.m_8055_(start.m_121945_(positive));
            if (cannonLength > MountedAutocannonContraption.getMaxCannonLength()) {
                throw MountedAutocannonContraption.cannonTooLarge();
            }
            if (!positiveBreech) continue;
        }
        BlockPos positiveEndPos = positiveBreech ? start : start.m_121945_(negative);
        start = pos;
        nextState = level.m_8055_(pos.m_121945_(negative));
        boolean negativeBreech = false;
        while ((block = nextState.m_60734_()) instanceof AutocannonBlock) {
            AutocannonBlock cBlock = (AutocannonBlock)block;
            if (!this.isConnectedToCannon((LevelAccessor)level, nextState, start.m_121945_(negative), negative, material)) break;
            start = start.m_121945_(negative);
            if (!cBlock.isComplete(nextState)) {
                throw MountedAutocannonContraption.hasIncompleteCannonBlocks(start);
            }
            cannonBlocks.add(new StructureTemplate.StructureBlockInfo(start, nextState, this.getBlockEntityNBT(level, start)));
            ++this.backExtensionLength;
            ++cannonLength;
            negativeBreech = cBlock.isBreechMechanism(nextState);
            if (negativeBreech && isStartBreech) {
                throw MountedAutocannonContraption.invalidCannon();
            }
            if (negativeBreech && cBlock.getFacing(nextState) != positive) {
                throw MountedAutocannonContraption.incorrectBreechDirection(start);
            }
            nextState = level.m_8055_(start.m_121945_(negative));
            if (cannonLength > MountedAutocannonContraption.getMaxCannonLength()) {
                throw MountedAutocannonContraption.cannonTooLarge();
            }
            if (!negativeBreech) continue;
        }
        BlockPos blockPos = negativeEndPos = negativeBreech ? start : start.m_121945_(positive);
        if (cannonLength < 2 || positiveBreech && negativeBreech) {
            throw MountedAutocannonContraption.invalidCannon();
        }
        this.startPos = !positiveBreech && !negativeBreech ? pos : (negativeBreech ? negativeEndPos : positiveEndPos);
        BlockState breechState = level.m_8055_(this.startPos);
        if (!(breechState.m_60734_() instanceof AutocannonBreechBlock)) {
            throw MountedAutocannonContraption.invalidCannon();
        }
        this.initialOrientation = (Direction)breechState.m_61143_((Property)BlockStateProperties.f_61372_);
        this.anchor = pos;
        this.startPos = this.startPos.m_121996_((Vec3i)pos);
        for (StructureTemplate.StructureBlockInfo blockInfo : cannonBlocks) {
            BlockPos localPos = blockInfo.f_74675_.m_121996_((Vec3i)pos);
            localBlockInfo = new StructureTemplate.StructureBlockInfo(localPos, blockInfo.f_74676_, blockInfo.f_74677_);
            this.blocks.put(localPos, localBlockInfo);
            if (blockInfo.f_74677_ == null) continue;
            BlockEntity be = BlockEntity.m_155241_((BlockPos)localPos, (BlockState)blockInfo.f_74676_, (CompoundTag)blockInfo.f_74677_);
            this.presentBlockEntities.put(localPos, be);
            if (!(blockInfo.f_74676_.m_60734_() instanceof AutocannonRecoilSpringBlock)) continue;
            this.recoilSpringPositions.add(localPos);
        }
        StructureTemplate.StructureBlockInfo startInfo = (StructureTemplate.StructureBlockInfo)this.blocks.get(this.startPos);
        if (startInfo == null || !(startInfo.f_74676_.m_60734_() instanceof AutocannonBreechBlock)) {
            throw MountedAutocannonContraption.noAutocannonBreech();
        }
        boolean bl = this.isHandle = startInfo.f_74676_.m_61138_((Property)AutocannonBreechBlock.HANDLE) && (Boolean)startInfo.f_74676_.m_61143_((Property)AutocannonBreechBlock.HANDLE) != false;
        if (this.isHandle) {
            this.getSeats().add(this.startPos.m_7949_());
        }
        if ((possibleSpring = (StructureTemplate.StructureBlockInfo)this.blocks.get(this.startPos.m_121945_(this.initialOrientation))) != null && (localBlockInfo = possibleSpring.f_74676_.m_60734_()) instanceof AutocannonRecoilSpringBlock && (springBlock = (AutocannonRecoilSpringBlock)localBlockInfo).getFacing(possibleSpring.f_74676_) == this.initialOrientation && (v = this.presentBlockEntities.get(mainRecoilSpringPos = this.startPos.m_121945_(this.initialOrientation).m_7949_())) instanceof AutocannonRecoilSpringBlockEntity) {
            AutocannonRecoilSpringBlockEntity springBE = (AutocannonRecoilSpringBlockEntity)v;
            for (int i = 1; i < cannonLength; ++i) {
                Block block4;
                BlockPos pos1 = this.startPos.m_5484_(this.initialOrientation, i);
                StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)this.blocks.get(pos1);
                if (blockInfo == null || !((block4 = blockInfo.f_74676_.m_60734_()) instanceof MovesWithAutocannonRecoilSpring)) continue;
                MovesWithAutocannonRecoilSpring springed = (MovesWithAutocannonRecoilSpring)block4;
                springBE.toAnimate.put(pos1.m_121996_((Vec3i)mainRecoilSpringPos), springed.getMovingState(blockInfo.f_74676_));
                this.blocks.put(pos1, new StructureTemplate.StructureBlockInfo(pos1, springed.getStationaryState(blockInfo.f_74676_), blockInfo.f_74677_));
            }
            CompoundTag newTag = springBE.m_187480_();
            newTag.m_128473_("x");
            newTag.m_128473_("y");
            newTag.m_128473_("z");
            this.blocks.put(mainRecoilSpringPos, new StructureTemplate.StructureBlockInfo(mainRecoilSpringPos, possibleSpring.f_74676_, newTag));
        }
        this.cannonMaterial = material;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isConnectedToCannon(LevelAccessor level, BlockState state, BlockPos pos, Direction connection, AutocannonMaterial material) {
        AutocannonBlock cBlock = (AutocannonBlock)state.m_60734_();
        if (cBlock.getAutocannonMaterialInLevel(level, state, pos) != material) {
            return false;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof IAutocannonBlockEntity)) return false;
        IAutocannonBlockEntity cbe = (IAutocannonBlockEntity)blockEntity;
        blockEntity = level.m_7702_(pos.m_121945_(connection.m_122424_()));
        if (!(blockEntity instanceof IAutocannonBlockEntity)) return false;
        IAutocannonBlockEntity cbe1 = (IAutocannonBlockEntity)blockEntity;
        if (!((ItemCannonBehavior)((Object)cbe.cannonBehavior())).isConnectedTo(connection.m_122424_())) return false;
        if (!((ItemCannonBehavior)((Object)cbe1.cannonBehavior())).isConnectedTo(connection)) return false;
        return true;
    }

    public static AssemblyException noAutocannonBreech() {
        return new AssemblyException((Component)Components.translatable((String)"exception.createbigcannons.cannon_mount.noAutocannonBreech"));
    }

    public void addBlocksToWorld(Level world, StructureTransform transform) {
        HashMap<BlockPos, StructureTemplate.StructureBlockInfo> modifiedBlocks = new HashMap<BlockPos, StructureTemplate.StructureBlockInfo>();
        for (Map.Entry entry : this.blocks.entrySet()) {
            StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)entry.getValue();
            BlockState newState = info.f_74676_;
            boolean modified = true;
            if (newState.m_61138_((Property)AutocannonBarrelBlock.ASSEMBLED) && ((Boolean)newState.m_61143_((Property)AutocannonBarrelBlock.ASSEMBLED)).booleanValue()) {
                newState = (BlockState)newState.m_61124_((Property)AutocannonBarrelBlock.ASSEMBLED, (Comparable)Boolean.valueOf(false));
                modified = true;
            }
            if (info.f_74677_ != null) {
                if (info.f_74677_.m_128441_("AnimateTicks")) {
                    info.f_74677_.m_128473_("AnimateTicks");
                    modified = true;
                }
                if (info.f_74677_.m_128441_("RenderedBlocks")) {
                    info.f_74677_.m_128473_("RenderedBlocks");
                    modified = true;
                }
            }
            if (!modified) continue;
            modifiedBlocks.put(info.f_74675_, new StructureTemplate.StructureBlockInfo(info.f_74675_, newState, info.f_74677_));
        }
        this.blocks.putAll(modifiedBlocks);
        super.addBlocksToWorld(world, transform);
    }

    @Override
    public void fireShot(ServerLevel level, PitchOrientedContraptionEntity entity) {
        Object v;
        AbstractAutocannonBreechBlockEntity breech;
        Object v2;
        if (this.startPos == null || this.cannonMaterial == null || !((v2 = this.presentBlockEntities.get(this.startPos)) instanceof AbstractAutocannonBreechBlockEntity) || !(breech = (AbstractAutocannonBreechBlockEntity)v2).canFire()) {
            return;
        }
        ItemStack foundProjectile = breech.extractNextInput();
        Item item = foundProjectile.m_41720_();
        if (!(item instanceof AutocannonAmmoItem)) {
            return;
        }
        AutocannonAmmoItem round = (AutocannonAmmoItem)item;
        ControlPitchContraption controller = entity.getController();
        Vec3 ejectPos = entity.toGlobalVector(Vec3.m_82512_((Vec3i)this.startPos.m_121945_(this.isHandle ? Direction.DOWN : this.initialOrientation.m_122424_())), 0.0f);
        Vec3 centerPos = entity.toGlobalVector(Vec3.m_82512_((Vec3i)BlockPos.f_121853_), 0.0f);
        ItemStack ejectStack = round.getSpentItem(foundProjectile);
        if (!ejectStack.m_41619_()) {
            ItemEntity ejectEntity = new ItemEntity((Level)level, ejectPos.f_82479_, ejectPos.f_82480_, ejectPos.f_82481_, ejectStack);
            Vec3 eject = ejectPos.m_82546_(centerPos).m_82541_();
            ejectEntity.m_20256_(eject.m_82490_(this.isHandle ? 0.1 : 0.5));
            ejectEntity.m_32010_(20);
            level.m_7967_((Entity)ejectEntity);
        }
        AutocannonMaterialProperties properties = this.cannonMaterial.properties();
        AutocannonProjectilePropertiesComponent roundProperties = round.getAutocannonProperties(foundProjectile);
        boolean canFail = (Boolean)CBCConfigs.SERVER.failure.disableAllFailure.get() == false;
        float speed = properties.baseSpeed();
        float spread = properties.baseSpread();
        boolean canSquib = roundProperties == null || roundProperties.canSquib();
        canSquib &= canFail;
        BlockPos currentPos = this.startPos.m_121945_(this.initialOrientation);
        int barrelTravelled = 0;
        boolean squib = false;
        while ((v = this.presentBlockEntities.get(currentPos)) instanceof IAutocannonBlockEntity) {
            IAutocannonBlockEntity autocannon = (IAutocannonBlockEntity)v;
            ItemCannonBehavior behavior = (ItemCannonBehavior)((Object)autocannon.cannonBehavior());
            if (behavior.canLoadItem(foundProjectile)) {
                if (++barrelTravelled <= properties.maxSpeedIncreases()) {
                    speed += properties.speedIncreasePerBarrel();
                }
                spread -= properties.spreadReductionPerBarrel();
                spread = Math.max(spread, 0.0f);
                if (canSquib && barrelTravelled > properties.maxBarrelLength()) {
                    StructureTemplate.StructureBlockInfo oldInfo = (StructureTemplate.StructureBlockInfo)this.blocks.get(currentPos);
                    if (oldInfo == null) {
                        return;
                    }
                    behavior.tryLoadingItem(foundProjectile);
                    CompoundTag tag = ((BlockEntity)this.presentBlockEntities.get(currentPos)).m_187480_();
                    tag.m_128473_("x");
                    tag.m_128473_("y");
                    tag.m_128473_("z");
                    StructureTemplate.StructureBlockInfo squibInfo = new StructureTemplate.StructureBlockInfo(currentPos, oldInfo.f_74676_, tag);
                    this.blocks.put(currentPos, squibInfo);
                    Vec3 squibPos = entity.toGlobalVector(Vec3.m_82512_((Vec3i)currentPos), 0.0f);
                    level.m_6263_(null, squibPos.f_82479_, squibPos.f_82480_, squibPos.f_82481_, oldInfo.f_74676_.m_60827_().m_56775_(), SoundSource.BLOCKS, 10.0f, 0.0f);
                    squib = true;
                    break;
                }
                currentPos = currentPos.m_121945_(this.initialOrientation);
                continue;
            }
            behavior.removeItem();
            if (!canFail) continue;
            Vec3 failurePoint = entity.toGlobalVector(Vec3.m_82512_((Vec3i)currentPos), 0.0f);
            level.m_46511_(null, failurePoint.f_82479_, failurePoint.f_82480_, failurePoint.f_82481_, 2.0f, Explosion.BlockInteraction.NONE);
            for (int i = 0; i < 10; ++i) {
                BlockPos pos = currentPos.m_5484_(this.initialOrientation, i);
                this.blocks.remove(pos);
            }
            if (controller != null) {
                controller.disassemble();
            }
            return;
        }
        breech.handleFiring();
        if (squib) {
            return;
        }
        for (BlockPos pos : this.recoilSpringPositions) {
            Object i = this.presentBlockEntities.get(pos);
            if (!(i instanceof AutocannonRecoilSpringBlockEntity)) continue;
            AutocannonRecoilSpringBlockEntity spring = (AutocannonRecoilSpringBlockEntity)i;
            spring.handleFiring();
        }
        NetworkPlatform.sendToClientTracking(new ClientboundAnimateCannonContraptionPacket((AbstractContraptionEntity)entity), (Entity)entity);
        Vec3 spawnPos = entity.toGlobalVector(Vec3.m_82512_((Vec3i)currentPos.m_121945_(this.initialOrientation)), 0.0f);
        Vec3 vec1 = spawnPos.m_82546_(centerPos).m_82541_();
        Vec3 particlePos = spawnPos = spawnPos.m_82546_(vec1.m_82490_(1.5));
        float recoilMagnitude = properties.baseRecoil();
        boolean isTracer = (Boolean)CBCConfigs.SERVER.munitions.allAutocannonProjectilesAreTracers.get() != false || round.isTracer(foundProjectile);
        AbstractAutocannonProjectile projectile = round.getAutocannonProjectile(foundProjectile, (Level)level);
        if (projectile != null) {
            projectile.m_146884_(spawnPos);
            projectile.setChargePower(barrelTravelled);
            projectile.setTracer(isTracer);
            projectile.setLifetime(properties.projectileLifetime());
            projectile.m_6686_(vec1.f_82479_, vec1.f_82480_, vec1.f_82481_, speed, spread);
            projectile.f_19860_ = projectile.m_146909_();
            projectile.f_19859_ = projectile.m_146908_();
            projectile.addUntouchableEntity((Entity)entity, 1);
            Entity vehicle = entity.m_20202_();
            if (vehicle != null && CBCEntityTypes.CANNON_CARRIAGE.is(vehicle)) {
                projectile.addUntouchableEntity(vehicle, 1);
            }
            level.m_7967_((Entity)projectile);
            if (roundProperties != null) {
                recoilMagnitude = (float)((double)recoilMagnitude + roundProperties.addedRecoil());
            }
        }
        recoilMagnitude *= CBCConfigs.SERVER.cannons.autocannonRecoilScale.getF();
        if (controller != null) {
            controller.onRecoil(vec1.m_82490_((double)(-recoilMagnitude)), (AbstractContraptionEntity)entity);
        }
        Vec3 particleVel = vec1.m_82490_(1.25);
        for (ServerPlayer player : level.m_6907_()) {
            if (entity.m_6688_() == player) continue;
            level.m_8624_(player, (ParticleOptions)new AutocannonPlumeParticleData(1.0f), true, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0, particleVel.f_82479_, particleVel.f_82480_, particleVel.f_82481_, 1.0);
        }
        if (round.getType() == AutocannonAmmoType.MACHINE_GUN) {
            CBCUtils.playBlastLikeSoundOnServer(level, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, CBCSoundEvents.FIRE_MACHINE_GUN.getMainEvent(), SoundSource.BLOCKS, 10.0f, 0.75f, 3.0f);
        } else {
            CBCUtils.playBlastLikeSoundOnServer(level, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, CBCSoundEvents.FIRE_AUTOCANNON.getMainEvent(), SoundSource.BLOCKS, 12.0f, 1.0f, 5.0f);
        }
        if (projectile != null && ((Boolean)CBCConfigs.SERVER.munitions.projectilesCanChunkload.get()).booleanValue()) {
            ChunkPos cpos1 = new ChunkPos(new BlockPos(projectile.m_20182_()));
            RitchiesProjectileLib.queueForceLoad((ServerLevel)level, (int)cpos1.f_45578_, (int)cpos1.f_45579_);
        }
    }

    @Override
    public void animate() {
        super.animate();
        Object v = this.presentBlockEntities.get(this.startPos);
        if (v instanceof AbstractAutocannonBreechBlockEntity) {
            AbstractAutocannonBreechBlockEntity breech = (AbstractAutocannonBreechBlockEntity)v;
            breech.handleFiring();
        }
        for (BlockPos pos : this.recoilSpringPositions) {
            Object v2 = this.presentBlockEntities.get(pos);
            if (!(v2 instanceof AutocannonRecoilSpringBlockEntity)) continue;
            AutocannonRecoilSpringBlockEntity spring = (AutocannonRecoilSpringBlockEntity)v2;
            spring.handleFiring();
        }
    }

    @Override
    public void tick(Level level, PitchOrientedContraptionEntity entity) {
        super.tick(level, entity);
        Entity controller = entity.m_6688_();
        if (this.canBeTurnedByPassenger(controller)) {
            Direction dir = entity.getInitialOrientation();
            boolean flag = dir.m_122421_() == Direction.AxisDirection.POSITIVE == (dir.m_122434_() == Direction.Axis.X);
            entity.pitch = flag ? -controller.f_19860_ : controller.f_19860_;
            entity.yaw = Mth.m_14177_((float)controller.f_19859_);
            controller.m_5618_(controller.m_146908_());
            if (CBCEntityTypes.CANNON_CARRIAGE.is(entity.m_20202_())) {
                entity.m_20202_().m_7340_((Entity)entity);
            } else if (entity.getController() instanceof CannonMountBlockEntity) {
                entity.m_146926_(entity.pitch);
                entity.m_146922_(entity.yaw);
            }
        }
        if (CBCEntityTypes.CANNON_CARRIAGE.is(entity.m_20202_())) {
            controller = entity.m_20202_().m_6688_();
        }
        if (!level.f_46443_ && controller instanceof Player) {
            ResourceLocation loc;
            Player player = (Player)controller;
            Object key = "";
            ControlPitchContraption controllerBlock = entity.getController();
            if (controllerBlock != null && (loc = controllerBlock.getTypeId()) != null) {
                key = "." + loc.m_135827_() + "." + loc.m_135815_();
            }
            player.m_5661_((Component)Components.translatable((String)("block.createbigcannons.cannon_carriage.hotbar.fireRate" + (String)key), (Object[])new Object[]{this.getReferencedFireRate()}), true);
        }
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            if (this.canBeFiredOnController(entity.getController())) {
                this.fireShot(slevel, entity);
            }
        }
        for (Map.Entry entry : this.presentBlockEntities.entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof IAutocannonBlockEntity)) continue;
            IAutocannonBlockEntity autocannon = (IAutocannonBlockEntity)v;
            autocannon.tickFromContraption(level, entity, (BlockPos)entry.getKey());
        }
    }

    @Override
    public BlockPos getSeatPos(Entity entity) {
        return entity == this.entity.m_6688_() ? this.startPos.m_121945_(this.initialOrientation.m_122424_()) : super.getSeatPos(entity);
    }

    @Override
    public boolean canBeTurnedByController(ControlPitchContraption control) {
        return !this.isHandle;
    }

    @Override
    public boolean canBeTurnedByPassenger(Entity entity) {
        return this.isHandle && entity instanceof Player;
    }

    @Override
    public boolean canBeFiredOnController(ControlPitchContraption control) {
        return !this.isHandle && this.entity.m_20202_() != control;
    }

    @Override
    public void onRedstoneUpdate(ServerLevel level, PitchOrientedContraptionEntity entity, boolean togglePower, int firePower, ControlPitchContraption controller) {
        Object v = this.presentBlockEntities.get(this.startPos);
        if (v instanceof AbstractAutocannonBreechBlockEntity) {
            AbstractAutocannonBreechBlockEntity breech = (AbstractAutocannonBreechBlockEntity)v;
            breech.setFireRate(firePower);
            BigCannonBlock.writeAndSyncSingleBlockData((BlockEntity)breech, (StructureTemplate.StructureBlockInfo)this.blocks.get(this.startPos), (AbstractContraptionEntity)entity, this);
        }
    }

    public void trySettingFireRateCarriage(int fireRateAdjustment) {
        Object v = this.presentBlockEntities.get(this.startPos);
        if (v instanceof AbstractAutocannonBreechBlockEntity) {
            AbstractAutocannonBreechBlockEntity breech = (AbstractAutocannonBreechBlockEntity)v;
            if (fireRateAdjustment > 0 || breech.getFireRate() > 1) {
                breech.setFireRate(breech.getFireRate() + fireRateAdjustment);
                BigCannonBlock.writeAndSyncSingleBlockData((BlockEntity)breech, (StructureTemplate.StructureBlockInfo)this.blocks.get(this.startPos), this.entity, this);
            }
        }
    }

    public int getReferencedFireRate() {
        int n;
        Object v = this.presentBlockEntities.get(this.startPos);
        if (v instanceof AbstractAutocannonBreechBlockEntity) {
            AbstractAutocannonBreechBlockEntity breech = (AbstractAutocannonBreechBlockEntity)v;
            n = breech.getActualFireRate();
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public float getWeightForStress() {
        return this.cannonMaterial == null ? (float)this.blocks.size() : (float)this.blocks.size() * this.cannonMaterial.properties().weight();
    }

    @Override
    public Vec3 getInteractionVec(PitchOrientedContraptionEntity poce) {
        return poce.toGlobalVector(Vec3.m_82512_((Vec3i)this.startPos), 0.0f);
    }

    @Override
    public ICannonContraptionType getCannonType() {
        return this.isHandle ? CBCCannonContraptionTypes.HANDLE_AUTOCANNON : CBCCannonContraptionTypes.AUTOCANNON;
    }

    @Override
    public CompoundTag writeNBT(boolean clientData) {
        CompoundTag tag = super.writeNBT(clientData);
        tag.m_128359_("AutocannonMaterial", this.cannonMaterial == null ? CBCAutocannonMaterials.CAST_IRON.name().toString() : this.cannonMaterial.name().toString());
        if (this.startPos != null) {
            tag.m_128365_("StartPos", (Tag)NbtUtils.m_129224_((BlockPos)this.startPos));
        }
        if (!this.recoilSpringPositions.isEmpty()) {
            ListTag positionsTag = new ListTag();
            for (BlockPos pos : this.recoilSpringPositions) {
                positionsTag.add((Object)NbtUtils.m_129224_((BlockPos)pos));
            }
            tag.m_128365_("RecoilSpringPositions", (Tag)positionsTag);
        }
        tag.m_128379_("IsHandle", this.isHandle);
        return tag;
    }

    @Override
    public void readNBT(Level level, CompoundTag tag, boolean clientData) {
        super.readNBT(level, tag, clientData);
        this.cannonMaterial = AutocannonMaterial.fromNameOrNull(CBCUtils.location(tag.m_128461_("AutocannonMaterial")));
        if (this.cannonMaterial == null) {
            this.cannonMaterial = CBCAutocannonMaterials.CAST_IRON;
        }
        this.startPos = tag.m_128441_("StartPos") ? NbtUtils.m_129239_((CompoundTag)tag.m_128469_("StartPos")) : null;
        this.recoilSpringPositions.clear();
        if (tag.m_128441_("RecoilSpringPositions")) {
            ListTag positionTags = tag.m_128437_("RecoilSpringPositions", 10);
            int sz = positionTags.size();
            for (int i = 0; i < sz; ++i) {
                this.recoilSpringPositions.add(NbtUtils.m_129239_((CompoundTag)positionTags.m_128728_(i)));
            }
        }
        this.isHandle = tag.m_128471_("IsHandle");
    }

    public ContraptionType getType() {
        return CBCContraptionTypes.MOUNTED_AUTOCANNON;
    }

    @Override
    public ItemStack insertItemIntoCannon(ItemStack stack, boolean simulate) {
        return stack;
    }

    @Override
    public ItemStack extractItemFromCannon(boolean simulate) {
        return ItemStack.f_41583_;
    }
}

