/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.effects.particles.plumes;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.foundation.particle.ICustomParticleData;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import rbasamoyai.createbigcannons.effects.particles.plumes.BigCannonPlumeParticle;
import rbasamoyai.createbigcannons.index.CBCParticleTypes;

public class BigCannonPlumeParticleData
implements ParticleOptions,
ICustomParticleData<BigCannonPlumeParticleData> {
    public static final Codec<BigCannonPlumeParticleData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.FLOAT.fieldOf("size").forGetter(data -> Float.valueOf(data.size)), (App)Codec.FLOAT.fieldOf("power").forGetter(data -> Float.valueOf(data.power)), (App)Codec.INT.fieldOf("lifetime").forGetter(data -> data.lifetime)).apply((Applicative)i, BigCannonPlumeParticleData::new));
    public static final ParticleOptions.Deserializer<BigCannonPlumeParticleData> DESERIALIZER = new ParticleOptions.Deserializer<BigCannonPlumeParticleData>(){

        public BigCannonPlumeParticleData fromNetwork(ParticleType<BigCannonPlumeParticleData> type, FriendlyByteBuf buf) {
            return new BigCannonPlumeParticleData(buf.readFloat(), buf.readFloat(), buf.m_130242_());
        }

        public BigCannonPlumeParticleData fromCommand(ParticleType<BigCannonPlumeParticleData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float size = reader.readFloat();
            reader.expect(' ');
            float power = reader.readFloat();
            reader.expect(' ');
            int lifetime = reader.readInt();
            return new BigCannonPlumeParticleData(size, power, lifetime);
        }
    };
    private final float size;
    private final float power;
    private final int lifetime;

    public BigCannonPlumeParticleData(float size, float power, int lifetime) {
        this.size = size;
        this.power = power;
        this.lifetime = lifetime;
    }

    public BigCannonPlumeParticleData(float size) {
        this(size, size, 10);
    }

    public BigCannonPlumeParticleData() {
        this(0.0f, 0.0f, 1);
    }

    public float size() {
        return this.size;
    }

    public float power() {
        return this.power;
    }

    public float lifetime() {
        return this.lifetime;
    }

    public ParticleType<?> m_6012_() {
        return CBCParticleTypes.BIG_CANNON_PLUME.get();
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeFloat(this.size).writeFloat(this.power);
        buf.m_130130_(this.lifetime);
    }

    public String m_5942_() {
        return String.format("%f %f %d", Float.valueOf(this.size), Float.valueOf(this.power), this.lifetime);
    }

    public ParticleOptions.Deserializer<BigCannonPlumeParticleData> getDeserializer() {
        return DESERIALIZER;
    }

    public Codec<BigCannonPlumeParticleData> getCodec(ParticleType<BigCannonPlumeParticleData> type) {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ParticleProvider<BigCannonPlumeParticleData> getFactory() {
        return new BigCannonPlumeParticle.Provider();
    }
}

