/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.forge.munitions.fluid_shell;

import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.Pair;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.AbstractFluidShellBlockEntity;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.EndFluidStack;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidShellProjectile;

public class FluidShellBlockEntity
extends AbstractFluidShellBlockEntity {
    protected FluidTank tank = new SmartFluidTank(FluidShellBlockEntity.getFluidShellCapacity(), this::onFluidStackChanged);
    private LazyOptional<IFluidHandler> fluidOptional;

    public FluidShellBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("FluidContent", (Tag)this.tank.writeToNBT(new CompoundTag()));
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.tank.readFromNBT(tag.m_128469_("FluidContent"));
    }

    @Override
    protected void setFluidShellStack(FluidShellProjectile shell) {
        FluidStack fstack = this.tank.getFluid();
        shell.setFluidStack(fstack.isEmpty() ? EndFluidStack.EMPTY : new EndFluidStack(fstack.getFluid(), fstack.getAmount(), fstack.getOrCreateTag()));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && side == this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_) && this.fuze.m_41619_()) {
            return this.getFluidOptional().cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean tryEmptyItemIntoTE(Level worldIn, Player player, InteractionHand handIn, ItemStack heldItem, Direction side) {
        if (this.hasFuze() || !GenericItemEmptying.canItemBeEmptied((Level)worldIn, (ItemStack)heldItem)) {
            return false;
        }
        if (worldIn.f_46443_) {
            return true;
        }
        Pair emptyingResult = GenericItemEmptying.emptyItem((Level)worldIn, (ItemStack)heldItem, (boolean)true);
        FluidStack fluidStack = (FluidStack)emptyingResult.getFirst();
        if (fluidStack.getAmount() != this.tank.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE)) {
            return false;
        }
        ItemStack copyOfHeld = heldItem.m_41777_();
        emptyingResult = GenericItemEmptying.emptyItem((Level)worldIn, (ItemStack)copyOfHeld, (boolean)false);
        this.tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
        if (!player.m_7500_()) {
            if (copyOfHeld.m_41619_()) {
                player.m_21008_(handIn, (ItemStack)emptyingResult.getSecond());
            } else {
                player.m_21008_(handIn, copyOfHeld);
                player.m_150109_().m_150079_((ItemStack)emptyingResult.getSecond());
            }
        }
        return true;
    }

    @Override
    public boolean tryFillItemFromTE(Level level, Player player, InteractionHand handIn, ItemStack heldItem, Direction side) {
        if (this.hasFuze() || !GenericItemFilling.canItemBeFilled((Level)level, (ItemStack)heldItem)) {
            return false;
        }
        if (level.f_46443_) {
            return true;
        }
        FluidStack fluid = this.tank.getFluid();
        if (fluid.isEmpty()) {
            return false;
        }
        int requiredAmountForItem = GenericItemFilling.getRequiredAmountForItem((Level)level, (ItemStack)heldItem, (FluidStack)fluid.copy());
        if (requiredAmountForItem == -1 || requiredAmountForItem > fluid.getAmount()) {
            return false;
        }
        if (player.m_7500_()) {
            heldItem = heldItem.m_41777_();
        }
        ItemStack out = GenericItemFilling.fillItem((Level)level, (int)requiredAmountForItem, (ItemStack)heldItem, (FluidStack)fluid.copy());
        FluidStack copy = fluid.copy();
        copy.setAmount(requiredAmountForItem);
        this.tank.drain(copy, IFluidHandler.FluidAction.EXECUTE);
        if (!player.m_7500_()) {
            player.m_150109_().m_150079_(out);
        }
        this.notifyUpdate();
        return true;
    }

    public LazyOptional<IFluidHandler> getFluidOptional() {
        if (this.fluidOptional == null) {
            this.fluidOptional = LazyOptional.of(() -> this.tank);
        }
        return this.fluidOptional;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.fluidOptional != null) {
            this.fluidOptional.invalidate();
        }
    }

    protected void onFluidStackChanged(FluidStack newStack) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.notifyUpdate();
        }
    }

    @Override
    protected void addFluidToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getFluidOptional());
    }
}

