/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.smoke_shell;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.effects.particles.smoke.SmokeShellSmokeParticleData;
import rbasamoyai.ritchiesprojectilelib.RitchiesProjectileLib;

public class SmokeEmitterEntity
extends Entity {
    private static final EntityDataAccessor<Float> SMOKE_SIZE_X = SynchedEntityData.m_135353_(SmokeEmitterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SMOKE_SIZE_Y = SynchedEntityData.m_135353_(SmokeEmitterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SMOKE_SIZE_Z = SynchedEntityData.m_135353_(SmokeEmitterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected int duration;
    protected int age;

    public SmokeEmitterEntity(EntityType<? extends SmokeEmitterEntity> type, Level level) {
        super(type, level);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SMOKE_SIZE_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SMOKE_SIZE_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SMOKE_SIZE_Z, (Object)Float.valueOf(0.0f));
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("Duration", this.duration);
        tag.m_128405_("Age", this.age);
        tag.m_128365_("Size", (Tag)this.m_20063_(new double[]{this.getSizeX(), this.getSizeY(), this.getSizeZ()}));
    }

    protected void m_7378_(CompoundTag tag) {
        this.duration = tag.m_128451_("Duration");
        ListTag sizeDims = tag.m_128437_("Size", 6);
        this.setSizeX((float)sizeDims.m_128772_(0));
        this.setSizeY((float)sizeDims.m_128772_(1));
        this.setSizeZ((float)sizeDims.m_128772_(2));
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setSize(float size) {
        this.f_19804_.m_135381_(SMOKE_SIZE_X, (Object)Float.valueOf(Math.abs(size)));
        this.f_19804_.m_135381_(SMOKE_SIZE_Y, (Object)Float.valueOf(Math.abs(size)));
        this.f_19804_.m_135381_(SMOKE_SIZE_Z, (Object)Float.valueOf(Math.abs(size)));
        this.m_20011_(this.m_142242_());
    }

    public float getMeanSize() {
        float sizeX = this.getSizeX();
        float sizeY = this.getSizeY();
        float sizeZ = this.getSizeZ();
        return (sizeX + sizeY + sizeZ) / 3.0f;
    }

    public float getVolume() {
        return this.getSizeX() * this.getSizeY() * this.getSizeZ();
    }

    public void setSizeX(float sizeX) {
        this.f_19804_.m_135381_(SMOKE_SIZE_X, (Object)Float.valueOf(Math.abs(sizeX)));
        this.m_20011_(this.m_142242_());
    }

    public float getSizeX() {
        return ((Float)this.f_19804_.m_135370_(SMOKE_SIZE_X)).floatValue();
    }

    public void setSizeY(float sizeY) {
        this.f_19804_.m_135381_(SMOKE_SIZE_Y, (Object)Float.valueOf(Math.abs(sizeY)));
        this.m_20011_(this.m_142242_());
    }

    public float getSizeY() {
        return ((Float)this.f_19804_.m_135370_(SMOKE_SIZE_Y)).floatValue();
    }

    public void setSizeZ(float sizeZ) {
        this.f_19804_.m_135381_(SMOKE_SIZE_Z, (Object)Float.valueOf(Math.abs(sizeZ)));
        this.m_20011_(this.m_142242_());
    }

    public float getSizeZ() {
        return ((Float)this.f_19804_.m_135370_(SMOKE_SIZE_Z)).floatValue();
    }

    public void m_8119_() {
        boolean doStuff = this.canDoStuff();
        if (this.f_19853_.f_46443_) {
            if (doStuff) {
                double sizeX = this.getSizeX();
                double sizeY = this.getSizeY();
                double sizeZ = this.getSizeZ();
                double count = Math.ceil(this.getMeanSize());
                ParticleOptions particle = this.getParticle();
                double baseX = this.m_20185_();
                double baseY = this.m_20186_();
                double baseZ = this.m_20189_();
                int i = 0;
                while ((double)i < count) {
                    double rx = this.f_19796_.m_188500_() * sizeX - sizeX * 0.5 + baseX;
                    double ry = this.f_19796_.m_188500_() * sizeY - sizeY * 0.5 + baseY;
                    double rz = this.f_19796_.m_188500_() * sizeZ - sizeZ * 0.5 + baseZ;
                    double dx = this.f_19796_.m_188583_() * 0.05;
                    double dy = this.f_19796_.m_188583_() * 0.02;
                    double dz = this.f_19796_.m_188583_() * 0.05;
                    this.f_19853_.m_6493_(particle, true, rx, ry, rz, dx, dy, dz);
                    ++i;
                }
            }
        } else {
            if (doStuff) {
                double sizeX = this.getSizeX();
                double sizeY = this.getSizeY();
                double sizeZ = this.getSizeZ();
                AABB bounding = this.m_20191_();
                AABB queryBounding = bounding.m_82400_(8.0);
                for (SmokeEmitterEntity other : this.f_19853_.m_6443_(SmokeEmitterEntity.class, queryBounding, this::canMergeWithOther)) {
                    double otherSizeX = other.getSizeX();
                    double otherSizeY = other.getSizeY();
                    double otherSizeZ = other.getSizeZ();
                    Vec3 disp = other.m_20182_().m_82546_(this.m_20182_());
                    Vec3 totalDims = new Vec3(sizeX + otherSizeX, sizeY + otherSizeY, sizeZ + otherSizeZ);
                    Vec3 maxSpacing = totalDims.m_82490_(0.55);
                    if (Math.abs(disp.f_82479_) > maxSpacing.f_82479_ || Math.abs(disp.f_82480_) > maxSpacing.f_82480_ || Math.abs(disp.f_82481_) > maxSpacing.f_82481_) continue;
                    AABB otherBounding = other.m_20191_();
                    bounding = new AABB(Math.min(bounding.f_82288_, otherBounding.f_82288_), Math.min(bounding.f_82289_, otherBounding.f_82289_), Math.min(bounding.f_82290_, otherBounding.f_82290_), Math.max(bounding.f_82291_, otherBounding.f_82291_), Math.max(bounding.f_82292_, otherBounding.f_82292_), Math.max(bounding.f_82293_, otherBounding.f_82293_));
                    this.mergeWith(other);
                    other.m_146870_();
                }
                this.setSizeX((float)bounding.m_82362_());
                this.setSizeY((float)bounding.m_82376_());
                this.setSizeZ((float)bounding.m_82385_());
                this.m_146884_(bounding.m_82399_());
            }
            ++this.age;
            if (this.age >= this.getLifetime()) {
                this.m_146870_();
                return;
            }
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel slevel = (ServerLevel)level;
                if (!this.m_213877_() && this.canChunkLoad()) {
                    ChunkPos cpos = new ChunkPos(this.m_20183_());
                    RitchiesProjectileLib.queueForceLoad((ServerLevel)slevel, (int)cpos.f_45578_, (int)cpos.f_45579_);
                }
            }
        }
        super.m_8119_();
    }

    protected boolean canDoStuff() {
        return this.f_19803_ || (this.f_19853_.m_46467_() + (long)this.m_19879_()) % 5L == 0L;
    }

    protected int getLifetime() {
        return this.duration;
    }

    protected boolean canChunkLoad() {
        return (Boolean)CBCConfigs.SERVER.munitions.smokeCloudsCanChunkload.get();
    }

    public boolean canMergeWithOther(SmokeEmitterEntity other) {
        return this != other && other.m_6095_() == this.m_6095_();
    }

    public void mergeWith(SmokeEmitterEntity other) {
        this.duration = Mth.m_14165_((double)((double)(this.duration + other.duration) / 2.0)) + 10;
        this.age = Math.max(Mth.m_14165_((double)((double)(this.age + other.age) / 2.0)) - 10, 0);
    }

    protected AABB m_142242_() {
        double sizeX = (double)this.getSizeX() * 0.5;
        double sizeY = (double)this.getSizeY() * 0.5;
        double sizeZ = (double)this.getSizeZ() * 0.5;
        return new AABB(this.m_20185_() + sizeX, this.m_20186_() + sizeY, this.m_20189_() + sizeZ, this.m_20185_() - sizeX, this.m_20186_() - sizeY, this.m_20189_() - sizeZ);
    }

    protected ParticleOptions getParticle() {
        return new SmokeShellSmokeParticleData(4.0f);
    }

    public boolean m_6087_() {
        return false;
    }
}

