/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight999.t_and_t.config.configs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cristelknight999.t_and_t.config.r.ConfigUtil;
import de.cristelknight999.t_and_t.config.r.JanksonOps;
import java.nio.file.Path;
import java.util.HashMap;
import net.minecraft.Util;

public record FrequencyConfig(Villages villages, Outposts pillagerOutposts, Others others) {
    public static final Codec<Outposts> CODEC_OUTPOST = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("spacing").orElse((Object)48).forGetter(config -> config.spacing), (App)Codec.INT.fieldOf("separation").orElse((Object)24).forGetter(config -> config.separation), (App)Codec.FLOAT.fieldOf("frequency").orElse((Object)Float.valueOf(0.2f)).forGetter(config -> Float.valueOf(config.frequency)), (App)Codec.INT.fieldOf("salt").orElse((Object)205745294).forGetter(config -> config.salt)).apply((Applicative)builder, Outposts::new));
    public static final Codec<Villages> CODEC_VILLAGE = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("spacing").orElse((Object)48).forGetter(config -> config.spacing), (App)Codec.INT.fieldOf("separation").orElse((Object)24).forGetter(config -> config.separation), (App)Codec.INT.fieldOf("salt").orElse((Object)10587309).forGetter(config -> config.salt)).apply((Applicative)builder, Villages::new));
    public static final Codec<Others> CODEC_OTHERS = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("spacing").orElse((Object)32).forGetter(config -> config.spacing), (App)Codec.INT.fieldOf("separation").orElse((Object)16).forGetter(config -> config.separation), (App)Codec.INT.fieldOf("salt").orElse((Object)30084234).forGetter(config -> config.salt)).apply((Applicative)builder, Others::new));
    public static final Path CONFIG_PATH = ConfigUtil.CONFIG_T_AND_T.resolve("structure_rarity.json5");
    private static FrequencyConfig INSTANCE = null;
    public static final FrequencyConfig DEFAULT = new FrequencyConfig(new Villages(48, 24, 10587309), new Outposts(48, 24, 0.2f, 205745294), new Others(32, 16, 30084234));
    public static final Codec<FrequencyConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CODEC_VILLAGE.fieldOf("villages").forGetter(ttConfig -> ttConfig.villages), (App)CODEC_OUTPOST.fieldOf("pillagerOutposts").forGetter(ttConfig -> ttConfig.pillagerOutposts), (App)CODEC_OTHERS.fieldOf("others").forGetter(ttConfig -> ttConfig.others)).apply((Applicative)builder, FrequencyConfig::new));
    public static final String HEADER_OPEN = "/*\nThis config file makes it possible to change the spacing, separation, salt (and frequency) of Towns and Towers' structure sets. Big thanks to Cristelknight for making this all possible.\n\tSPACING ---  controls how far a structure can be from others of its kind\n\tSEPARATION --- controls how close to each other two structures of the same type can be.\nBy default, the values should be 48/24 for villages and outposts (spacing/separation respectively) - a hypothetical village is going to appear not further than 48 chunks away (ca. 760 blocks), but not closer than 24 chunks (ca. 380 blocks).\n       * If you want a structure to spawn more frequently, decrease those values.\n       * If you want a structure to spawn less frequently, increase those values.\nKEEP IN MIND THAT SPACING ALWAYS NEEDS TO BE HIGHER THAN SEPARATION.\n\nLINKS\n=====\nCurseforge link: https://www.curseforge.com/minecraft/mc-mods/towns-and-towers\nModrinth link: https://modrinth.com/mod/towns-and-towers\nPMC link: https://www.planetminecraft.com/data-pack/towns-amp-towers-structure-overhaul/\nGitHub Repository: [NEED TO MAKE ONE]\n";
    public static final String HEADER_CLOSED = "/*\nThis config file makes it possible to change the spacing, separation, salt (and frequency) of Towns and Towers' structure sets. Big thanks to Cristelknight for making this all possible.\n\tSPACING ---  controls how far a structure can be from others of its kind\n\tSEPARATION --- controls how close to each other two structures of the same type can be.\nBy default, the values should be 48/24 for villages and outposts (spacing/separation respectively) - a hypothetical village is going to appear not further than 48 chunks away (ca. 760 blocks), but not closer than 24 chunks (ca. 380 blocks).\n       * If you want a structure to spawn more frequently, decrease those values.\n       * If you want a structure to spawn less frequently, increase those values.\nKEEP IN MIND THAT SPACING ALWAYS NEEDS TO BE HIGHER THAN SEPARATION.\n\nLINKS\n=====\nCurseforge link: https://www.curseforge.com/minecraft/mc-mods/towns-and-towers\nModrinth link: https://modrinth.com/mod/towns-and-towers\nPMC link: https://www.planetminecraft.com/data-pack/towns-amp-towers-structure-overhaul/\nGitHub Repository: [NEED TO MAKE ONE]\n*/";

    public static FrequencyConfig getConfig() {
        return FrequencyConfig.getConfig(false, false);
    }

    public static FrequencyConfig getConfig(boolean serialize, boolean recreate) {
        if (INSTANCE == null || serialize || recreate) {
            Path path = CONFIG_PATH;
            if (!path.toFile().exists() || recreate) {
                FrequencyConfig.createConfig(path);
            }
            INSTANCE = ConfigUtil.readConfig(path, CODEC, JanksonOps.INSTANCE);
        }
        return INSTANCE;
    }

    public static void setINSTANCE(FrequencyConfig config) {
        INSTANCE = config;
    }

    private static void createConfig(Path path) {
        HashMap comments = (HashMap)Util.m_137469_(new HashMap(), map -> {
            map.put("pillagerOutposts", "Here you can find all outposts.");
            map.put("villages", "Here you can find all villages.");
            map.put("others", "Here you can find all structures that aren't villages or outposts.");
            map.put("pillagerOutposts.spacing", "DEFAULT 48");
            map.put("villages.spacing", "DEFAULT 48");
            map.put("others.spacing", "DEFAULT 32");
            map.put("others.separation", "DEFAULT 16");
            map.put("pillagerOutposts.separation", "DEFAULT 24");
            map.put("villages.separation", "DEFAULT 24");
            map.put("pillagerOutposts.frequency", "DEFAULT 0.2");
        });
        if (INSTANCE == null) {
            INSTANCE = DEFAULT;
        }
        ConfigUtil.createConfig(path, CODEC, HEADER_CLOSED, comments, JanksonOps.INSTANCE, INSTANCE);
    }

    public record Villages(int spacing, int separation, int salt) {
    }

    public record Outposts(int spacing, int separation, float frequency, int salt) {
    }

    public record Others(int spacing, int separation, int salt) {
    }
}

