/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.connector;

import com.mrh0.createaddition.blocks.connector.ConnectorType;
import com.mrh0.createaddition.blocks.connector.SmallLightConnectorBlock;
import com.mrh0.createaddition.blocks.connector.base.AbstractConnectorBlock;
import com.mrh0.createaddition.blocks.connector.base.AbstractConnectorBlockEntity;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SmallLightConnectorBlockEntity
extends AbstractConnectorBlockEntity {
    private static final float OFFSET_HEIGHT = 5.5f;
    public static final Vec3 OFFSET_DOWN = new Vec3(0.0, -0.34375, 0.0);
    public static final Vec3 OFFSET_UP = new Vec3(0.0, 0.34375, 0.0);
    public static final Vec3 OFFSET_NORTH = new Vec3(0.0, 0.0, -0.34375);
    public static final Vec3 OFFSET_WEST = new Vec3(-0.34375, 0.0, 0.0);
    public static final Vec3 OFFSET_SOUTH = new Vec3(0.0, 0.0, 0.34375);
    public static final Vec3 OFFSET_EAST = new Vec3(0.34375, 0.0, 0.0);
    private int posTimeOffset = 0;
    private int tickToggleTimer = 0;

    public SmallLightConnectorBlockEntity(BlockEntityType<?> blockEntityTypeIn, BlockPos pos, BlockState state) {
        super(blockEntityTypeIn, pos, state);
        this.posTimeOffset = 10 + Math.abs(pos.m_123341_() * 31 + pos.m_123342_() * 45 + pos.m_123343_() * 33) % 7 * 3;
    }

    @Override
    public void read(CompoundTag nbt, boolean clientPacket) {
        this.tickToggleTimer = nbt.m_128451_("tick_toggle_timer");
        super.read(nbt, clientPacket);
    }

    @Override
    public void write(CompoundTag nbt, boolean clientPacket) {
        nbt.m_128405_("tick_toggle_timer", this.tickToggleTimer);
        super.write(nbt, clientPacket);
    }

    public void addBehaviours(List<BlockEntityBehaviour> list) {
    }

    @Override
    public int getMaxIn() {
        return (Integer)Config.SMALL_CONNECTOR_MAX_INPUT.get();
    }

    @Override
    public int getMaxOut() {
        return (Integer)Config.SMALL_CONNECTOR_MAX_OUTPUT.get();
    }

    @Override
    public int getNodeCount() {
        return 4;
    }

    @Override
    public Vec3 getNodeOffset(int node) {
        return switch ((Direction)this.m_58900_().m_61143_((Property)AbstractConnectorBlock.FACING)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> OFFSET_DOWN;
            case Direction.UP -> OFFSET_UP;
            case Direction.NORTH -> OFFSET_NORTH;
            case Direction.WEST -> OFFSET_WEST;
            case Direction.SOUTH -> OFFSET_SOUTH;
            case Direction.EAST -> OFFSET_EAST;
        };
    }

    @Override
    public ConnectorType getConnectorType() {
        return ConnectorType.Small;
    }

    @Override
    public int getMaxWireLength() {
        return (Integer)Config.SMALL_CONNECTOR_MAX_LENGTH.get();
    }

    @Override
    protected void specialTick() {
        if (this.m_58904_() == null) {
            return;
        }
        if (this.f_58857_.m_5776_()) {
            return;
        }
        EnergyNetwork network = this.getNetwork(0);
        boolean hasEnergy = network != null && network.pull((Integer)Config.SMALL_LIGHT_CONNECTOR_CONSUMPTION.get(), false) > 0;
        this.tickToggleTimer += hasEnergy ? 1 : -1;
        if (this.tickToggleTimer >= this.posTimeOffset) {
            this.tickToggleTimer = this.posTimeOffset;
            if (!((Boolean)this.m_58900_().m_61143_((Property)SmallLightConnectorBlock.POWERED)).booleanValue()) {
                this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)SmallLightConnectorBlock.POWERED, (Comparable)Boolean.valueOf(true)));
            }
        }
        if (this.tickToggleTimer <= -this.posTimeOffset) {
            this.tickToggleTimer = -this.posTimeOffset;
            if (((Boolean)this.m_58900_().m_61143_((Property)SmallLightConnectorBlock.POWERED)).booleanValue()) {
                this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)SmallLightConnectorBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }
}

