/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.api;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.rechiseled.texture.TextureMappingTool;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class ChiseledTextureProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private final String modid;
    private final DataGenerator generator;
    private final ExistingFileHelper existingFileHelper;
    private final Map<Pair<ResourceLocation, ResourceLocation>, PaletteMap> textures = new HashMap<Pair<ResourceLocation, ResourceLocation>, PaletteMap>();
    private final Set<String> outputLocations = new HashSet<String>();
    private final List<String> oakPlankSuffixes;

    public ChiseledTextureProvider(String modid, DataGenerator generator, ExistingFileHelper existingFileHelper) {
        this.modid = modid;
        this.generator = generator;
        this.existingFileHelper = existingFileHelper;
        this.oakPlankSuffixes = TextureMappingTool.getSuffixes("oak_planks", existingFileHelper);
    }

    public String m_6055_() {
        return "Chiseled Textures: " + this.modid;
    }

    public void m_213708_(CachedOutput cache) throws IOException {
        this.createTextures();
        Path path = this.generator.m_123916_();
        for (Map.Entry<Pair<ResourceLocation, ResourceLocation>, PaletteMap> entry : this.textures.entrySet()) {
            if (entry.getValue().targets.isEmpty()) continue;
            Pair<BufferedImage, JsonObject> oldPalette = this.loadTexture((ResourceLocation)entry.getKey().left());
            Pair<BufferedImage, JsonObject> newPalette = this.loadTexture((ResourceLocation)entry.getKey().right());
            Map<String, ResourceLocation> targets = entry.getValue().targets;
            boolean ignoreMissingColors = entry.getValue().ignoreMissingColors;
            Map<Integer, Integer> colorMap = TextureMappingTool.createPaletteMap((BufferedImage)oldPalette.left(), (BufferedImage)newPalette.left());
            for (Map.Entry<String, ResourceLocation> target : targets.entrySet()) {
                Pair<BufferedImage, JsonObject> targetTexture = this.loadTexture(target.getValue());
                String outputLocation = target.getKey();
                TextureMappingTool.applyPaletteMap((BufferedImage)targetTexture.left(), colorMap, ignoreMissingColors, outputLocation);
                Path texturePath = path.resolve("assets/" + this.modid + "/textures/" + outputLocation + ".png");
                ChiseledTextureProvider.saveTexture(cache, (BufferedImage)targetTexture.left(), texturePath);
                if (targetTexture.right() == null) continue;
                Path textureMetadataPath = path.resolve("assets/" + this.modid + "/textures/" + outputLocation + ".png.mcmeta");
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)((JsonElement)targetTexture.right()), (Path)textureMetadataPath);
            }
        }
    }

    private Pair<BufferedImage, JsonObject> loadTexture(ResourceLocation location) {
        BufferedImage image;
        if (!this.existingFileHelper.exists(location, PackType.CLIENT_RESOURCES, ".png", "textures")) {
            throw new IllegalStateException("Could not find existing texture: " + location);
        }
        boolean hasMetadata = this.existingFileHelper.exists(location, PackType.CLIENT_RESOURCES, ".png.mcmeta", "textures");
        JsonObject metadata = null;
        if (hasMetadata) {
            try (BufferedReader reader = this.existingFileHelper.getResource(location, PackType.CLIENT_RESOURCES, ".png.mcmeta", "textures").m_215508_();){
                metadata = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered an exception when trying to load texture metadata: " + location, e);
            }
        }
        try (InputStream stream = this.existingFileHelper.getResource(location, PackType.CLIENT_RESOURCES, ".png", "textures").m_215507_();){
            image = ImageIO.read(stream);
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception when trying to load texture: " + location, e);
        }
        if (image.getType() != 2) {
            BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            Graphics2D graphics = newImage.createGraphics();
            graphics.drawImage((Image)image, 0, 0, null);
            graphics.dispose();
            image = newImage;
        }
        return Pair.of((Object)image, (Object)metadata);
    }

    private static void saveTexture(CachedOutput cache, BufferedImage image, Path path) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", byteArrayOutputStream);
            byte[] bytes = byteArrayOutputStream.toByteArray();
            HashCode hash = Hashing.sha1().hashBytes(bytes);
            cache.m_213871_(path, bytes, hash);
        }
        catch (IOException exception) {
            System.err.println("Couldn't save texture '" + path + "'");
            exception.printStackTrace();
        }
    }

    private boolean validateTexture(ResourceLocation texture) {
        return this.existingFileHelper.exists(texture, PackType.CLIENT_RESOURCES, ".png", "textures");
    }

    private void trackTexture(String outputLocation) {
        this.existingFileHelper.trackGenerated(new ResourceLocation(this.modid, outputLocation), PackType.CLIENT_RESOURCES, ".png", "textures");
    }

    protected abstract void createTextures();

    protected PaletteMap createPaletteMap(ResourceLocation oldPalette, ResourceLocation newPalette) {
        if (!this.validateTexture(oldPalette)) {
            throw new IllegalStateException("Could not find texture '" + oldPalette + "'!");
        }
        if (!this.validateTexture(newPalette)) {
            throw new IllegalStateException("Could not find texture '" + newPalette + "'!");
        }
        return this.textures.computeIfAbsent((Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)oldPalette, (Object)newPalette), o -> new PaletteMap());
    }

    protected void createPlankTextures(ResourceLocation plankTexture, String outputLocation) {
        if (!this.validateTexture(plankTexture)) {
            throw new IllegalStateException("Could not find texture '" + plankTexture + "'!");
        }
        if (outputLocation == null || outputLocation.trim().isEmpty()) {
            throw new IllegalArgumentException("Output location must not be empty!");
        }
        if (!this.outputLocations.add(outputLocation)) {
            throw new IllegalStateException("Two or more textures have the same output location: " + outputLocation);
        }
        PaletteMap paletteMap = this.createPaletteMap(new ResourceLocation("minecraft", "block/oak_planks"), plankTexture);
        for (String suffix : this.oakPlankSuffixes) {
            paletteMap.applyToTexture(new ResourceLocation("rechiseled", "block/oak_planks" + suffix), outputLocation + suffix);
        }
    }

    protected class PaletteMap {
        private final Map<String, ResourceLocation> targets = new HashMap<String, ResourceLocation>();
        private boolean ignoreMissingColors = false;

        private PaletteMap() {
        }

        public PaletteMap applyToTexture(ResourceLocation texture, String outputLocation) {
            if (!ChiseledTextureProvider.this.validateTexture(texture)) {
                throw new IllegalStateException("Could not find texture '" + texture + "'!");
            }
            if (outputLocation == null || outputLocation.trim().isEmpty()) {
                throw new IllegalArgumentException("Output location must not be empty!");
            }
            if (!ChiseledTextureProvider.this.outputLocations.add(outputLocation)) {
                throw new IllegalStateException("Two or more textures have the same output location: " + outputLocation);
            }
            this.targets.put(outputLocation.toLowerCase(Locale.ROOT).trim(), texture);
            ChiseledTextureProvider.this.trackTexture(outputLocation);
            return this;
        }

        public PaletteMap ignoreMissing() {
            this.ignoreMissingColors = true;
            return this;
        }
    }
}

