/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.config;

import com.hlysine.create_connected.CreateConnected;
import com.simibubi.create.foundation.config.ConfigBase;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;

public abstract class SyncConfigBase
extends ConfigBase {
    private SimpleChannel syncChannel;
    private Function<CompoundTag, ? extends SyncConfig> messageSupplier;

    public final CompoundTag getSyncConfig() {
        CompoundTag nbt = new CompoundTag();
        this.writeSyncConfig(nbt);
        if (this.children != null) {
            for (ConfigBase child : this.children) {
                if (!(child instanceof SyncConfigBase)) continue;
                SyncConfigBase syncChild = (SyncConfigBase)child;
                if (nbt.m_128441_(child.getName())) {
                    throw new RuntimeException("A sync config key starts with " + child.getName() + " but does not belong to the child");
                }
                nbt.m_128365_(child.getName(), (Tag)syncChild.getSyncConfig());
            }
        }
        return nbt;
    }

    protected void writeSyncConfig(CompoundTag nbt) {
    }

    public final void setSyncConfig(CompoundTag config) {
        if (this.children != null) {
            for (ConfigBase child : this.children) {
                if (!(child instanceof SyncConfigBase)) continue;
                SyncConfigBase syncChild = (SyncConfigBase)child;
                CompoundTag nbt = config.m_128469_(child.getName());
                syncChild.readSyncConfig(nbt);
            }
        }
        this.readSyncConfig(config);
    }

    protected void readSyncConfig(CompoundTag nbt) {
    }

    public <T extends SyncConfig> void registerAsSyncRoot(String configVersion, Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer, Function<CompoundTag, T> messageSupplier) {
        this.syncChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)CreateConnected.asResource("config_" + this.getName()), () -> configVersion, configVersion::equals, configVersion::equals);
        this.syncChannel.registerMessage(0, messageType, encoder, decoder, messageConsumer);
        this.messageSupplier = messageSupplier;
        MinecraftForge.EVENT_BUS.addListener(this::syncToPlayer);
    }

    public void onLoad() {
        super.onLoad();
        this.syncToAllPlayers();
    }

    public void onReload() {
        super.onReload();
        this.syncToAllPlayers();
    }

    public void syncToAllPlayers() {
        if (this.syncChannel == null) {
            return;
        }
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            CreateConnected.LOGGER.debug("Sync Config: Config sync skipped due to null server");
            return;
        }
        CreateConnected.LOGGER.debug("Sync Config: Sending server config to all players on reload");
        this.syncChannel.send(PacketDistributor.ALL.noArg(), (Object)this.messageSupplier.apply(this.getSyncConfig()));
    }

    private void syncToPlayer(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (player == null) {
            return;
        }
        CreateConnected.LOGGER.debug("Sync Config: Sending server config to " + player.m_6302_());
        this.syncChannel.send(PacketDistributor.PLAYER.with(() -> player), (Object)this.messageSupplier.apply(this.getSyncConfig()));
    }

    public static abstract class SyncConfig {
        private final CompoundTag nbt;

        protected SyncConfig(CompoundTag nbt) {
            this.nbt = nbt;
        }

        protected abstract SyncConfigBase configInstance();

        void encode(FriendlyByteBuf buf) {
            buf.m_130079_(this.nbt);
        }

        static CompoundTag decode(FriendlyByteBuf buf) {
            return buf.m_130261_();
        }

        void handle(Supplier<NetworkEvent.Context> context) {
            NetworkEvent.Context ctx = context.get();
            ctx.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                this.configInstance().setSyncConfig(this.nbt);
                CreateConnected.LOGGER.debug("Sync Config: Received and applied server config " + this.nbt.toString());
            }));
            ctx.setPacketHandled(true);
        }
    }
}

