/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.gravisuit.items.tools;

import com.google.common.base.CaseFormat;
import ic2.core.utils.helpers.StackUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public enum DrillMode {
    NORMAL(ChatFormatting.AQUA),
    LOW_POWER(ChatFormatting.DARK_GREEN),
    FINE(ChatFormatting.GOLD),
    BIG_HOLES(ChatFormatting.LIGHT_PURPLE);

    private static final DrillMode[] VALUES;
    public final ChatFormatting color;
    public final String name = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_UNDERSCORE, this.name());
    public final String localeName = "message.text.mode." + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_UNDERSCORE, this.name());

    private DrillMode(ChatFormatting color) {
        this.color = color;
    }

    public static DrillMode getFromId(int ID) {
        return VALUES[ID % VALUES.length];
    }

    public static DrillMode getDrillMode(ItemStack tool) {
        CompoundTag tag = StackUtil.getNbtData((ItemStack)tool);
        return DrillMode.getFromId(tag.m_128445_("mode"));
    }

    public static DrillMode getNextDrillMode(ItemStack tool) {
        CompoundTag tag = StackUtil.getNbtData((ItemStack)tool);
        return DrillMode.getFromId(tag.m_128445_("mode") + 1);
    }

    public static void saveDrillMode(ItemStack tool, DrillMode mode) {
        CompoundTag tag = tool.m_41784_();
        tag.m_128344_("mode", (byte)mode.ordinal());
    }

    static {
        VALUES = DrillMode.values();
    }
}

