/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.gravisuit.items.tools;

import com.google.common.base.CaseFormat;
import ic2.api.items.electric.ElectricItem;
import ic2.api.tiles.teleporter.TeleporterTarget;
import ic2.core.IC2;
import ic2.core.audio.AudioManager;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.base.IHasHeldGui;
import ic2.core.inventory.base.IPortableInventory;
import ic2.core.item.base.IC2ElectricItem;
import ic2.core.platform.player.KeyHelper;
import ic2.core.platform.rendering.IC2Textures;
import ic2.core.platform.rendering.features.item.ISimpleItemModel;
import ic2.core.utils.helpers.StackUtil;
import ic2.core.utils.helpers.TeleportUtil;
import ic2.core.utils.tooltips.ToolTipHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import trinsdar.gravisuit.entity.PlasmaBall;
import trinsdar.gravisuit.items.container.ItemInventoryRelocator;
import trinsdar.gravisuit.util.GravisuitConfig;
import trinsdar.gravisuit.util.GravisuitLang;
import trinsdar.gravisuit.util.Registry;

public class ItemRelocator
extends IC2ElectricItem
implements ISimpleItemModel,
IHasHeldGui {
    public ItemRelocator() {
        super("relocator");
        Registry.REGISTRY.put(new ResourceLocation("gravisuit", "relocator"), (Item)this);
    }

    protected int getEnergyCost(ItemStack itemStack) {
        return 1000000;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public int getCapacity(ItemStack stack) {
        return GravisuitConfig.RELOCATOR_STORAGE.get();
    }

    public int getTier(ItemStack itemStack) {
        return 5;
    }

    public int getTransferLimit(ItemStack stack) {
        return GravisuitConfig.RELOCATOR_TRANSFER.get();
    }

    public IPortableInventory getInventory(Player player, InteractionHand interactionHand, ItemStack itemStack) {
        return new ItemInventoryRelocator(player, this, itemStack, interactionHand);
    }

    public void addToolTip(ItemStack stack, Player player, TooltipFlag type, ToolTipHelper helper) {
        super.addToolTip(stack, player, type, helper);
        TeleportMode mode = ItemRelocator.getTeleportMode(stack);
        helper.addSimpleToolTip(Component.m_237110_((String)"item_info.toolMode", (Object[])new Object[]{Component.m_237115_((String)mode.localeName).m_130940_(mode.color)}).m_130940_(ChatFormatting.BLUE));
        helper.addKeybindingTooltip(this.buildKeyDescription(KeyHelper.MODE_KEY, KeyHelper.RIGHT_CLICK, new Object[]{Component.m_237115_((String)"item_info.multiModes").m_130940_(ChatFormatting.GRAY)}));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag nbt = stack.m_41784_();
        if (IC2.PLATFORM.isSimulating() && IC2.KEYBOARD.isModeSwitchKeyDown(player)) {
            TeleportMode nextMode = ItemRelocator.getNextTeleportMode(stack);
            ItemRelocator.saveTeleportMode(stack, nextMode);
            player.m_5661_((Component)Component.m_237110_((String)"message.relocator", (Object[])new Object[]{Component.m_237115_((String)nextMode.localeName).m_130940_(nextMode.color)}).m_130940_(ChatFormatting.YELLOW), false);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (IC2.PLATFORM.isSimulating()) {
            String name;
            CompoundTag map;
            TeleportMode mode = ItemRelocator.getTeleportMode(stack);
            if (player.m_6047_() || mode == TeleportMode.PERSONAL) {
                IC2.PLATFORM.launchGui(player, hand, null, (IHasGui)this.getInventory(player, hand, stack));
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            if (nbt.m_128441_("DefaultLocation") && nbt.m_128441_("Locations") && (map = nbt.m_128469_("Locations")).m_128441_(name = nbt.m_128461_("DefaultLocation"))) {
                int use;
                boolean portal = mode == TeleportMode.PORTAL;
                int n = use = portal ? 10000000 : 500000;
                if (ElectricItem.MANAGER.canUse(stack, use)) {
                    PlasmaBall entity = new PlasmaBall(player.f_19853_, player, TeleportData.fromNBT(map.m_128469_(name), name), hand);
                    level.m_7967_((Entity)entity);
                    if (portal) {
                        ElectricItem.MANAGER.use(stack, use, (LivingEntity)player);
                    }
                } else {
                    player.m_213846_((Component)this.translate(GravisuitLang.messageRelocatorNotEnoughPower, new ChatFormatting[]{ChatFormatting.RED}));
                }
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        }
        return super.m_7203_(level, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)IC2Textures.getMappedEntriesItem((String)"gravisuit", (String)"tools").get("relocator");
    }

    public static void teleportEntity(Player player, CompoundTag teleportData, ItemStack stack) {
        Registry.RELOCATOR.teleportEntity((LivingEntity)player, TeleporterTarget.read((CompoundTag)teleportData), player.m_6374_(), stack);
    }

    public void teleportEntity(LivingEntity player, TeleporterTarget target, Direction dir, ItemStack stack) {
        int weight = TeleportUtil.getWeightOfEntity((Entity)player, (boolean)true);
        if (weight != 0) {
            ServerLevel server = target.getWorld();
            BlockPos pos = target.getTargetPosition();
            if (ElectricItem.MANAGER.use(stack, (int)((double)weight * TeleportUtil.getDistanceCost((Level)player.m_9236_(), (BlockPos)player.m_20183_(), (Level)server, (BlockPos)pos) * 5.0), player)) {
                TeleportUtil.teleportEntity((Entity)player, (ServerLevel)server, (BlockPos)pos, (Direction)dir);
                IC2.AUDIO.playSound((Object)player, new ResourceLocation("ic2", "sounds/machines/teleport.ogg"), AudioManager.SoundType.ITEM);
            } else {
                player.m_213846_((Component)this.translate(GravisuitLang.messageRelocatorNotEnoughPower, new ChatFormatting[]{ChatFormatting.RED}));
            }
        }
    }

    public static TeleportMode getTeleportMode(ItemStack tool) {
        CompoundTag tag = StackUtil.getNbtData((ItemStack)tool);
        return TeleportMode.getFromId(tag.m_128445_("mode"));
    }

    public static TeleportMode getNextTeleportMode(ItemStack tool) {
        CompoundTag tag = StackUtil.getNbtData((ItemStack)tool);
        return TeleportMode.getFromId(tag.m_128445_("mode") + 1);
    }

    public static void saveTeleportMode(ItemStack tool, TeleportMode mode) {
        CompoundTag tag = StackUtil.getNbtData((ItemStack)tool);
        tag.m_128344_("mode", (byte)mode.ordinal());
    }

    public static enum TeleportMode {
        PERSONAL(ChatFormatting.GREEN),
        TRANSLOCATOR(ChatFormatting.GOLD),
        PORTAL(ChatFormatting.AQUA);

        private static final TeleportMode[] VALUES;
        public final ChatFormatting color;
        public final String name = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_UNDERSCORE, this.name());
        public final String localeName = "message.text.mode." + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_UNDERSCORE, this.name());

        private TeleportMode(ChatFormatting color) {
            this.color = color;
        }

        public static TeleportMode getFromId(int ID) {
            return VALUES[ID % VALUES.length];
        }

        static {
            VALUES = TeleportMode.values();
        }
    }

    public static class TeleportData {
        long pos;
        String dimId;
        String name;

        public TeleportData(long pos, String dimId, String name) {
            this.pos = pos;
            this.dimId = dimId;
            this.name = name;
        }

        public TeleportData(String name) {
            this.pos = 0L;
            this.dimId = "minecraft:overworld";
            this.name = name;
        }

        public long getPos() {
            return this.pos;
        }

        public String getDimId() {
            return this.dimId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDimId(String dimId) {
            this.dimId = dimId;
        }

        public CompoundTag writeToNBT() {
            CompoundTag compound = new CompoundTag();
            compound.m_128356_("pos", this.pos);
            compound.m_128359_("id", this.dimId);
            return compound;
        }

        public static TeleportData fromNBT(CompoundTag tag, String name) {
            return new TeleportData(tag.m_128454_("pos"), tag.m_128461_("id"), name);
        }

        public TeleporterTarget toTeleportTarget() {
            CompoundTag compoundTag = this.writeToNBT();
            return TeleporterTarget.read((CompoundTag)compoundTag);
        }
    }
}

