/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.gravisuit.mixin;

import ic2.core.IC2;
import ic2.core.item.tool.electric.AdvancedChainsaw;
import ic2.core.item.tool.electric.ChainsawTool;
import ic2.core.platform.player.KeyHelper;
import ic2.core.platform.rendering.IC2Textures;
import ic2.core.utils.helpers.StackUtil;
import ic2.core.utils.tooltips.ToolTipHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AdvancedChainsaw.class})
public class AdvancedChainsawMixin
extends ChainsawTool {
    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void injectInit(CallbackInfo ci) {
        this.tier = 2;
    }

    @Redirect(method={"onBlockStartBreak"}, at=@At(value="INVOKE", target="Lic2/core/item/tool/electric/ChainsawTool;onBlockStartBreak(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;)Z"), remap=false)
    private boolean redirectOnBlockStartBreak(ChainsawTool instance, ItemStack stack, BlockPos pos, Player player) {
        if (!StackUtil.getNbtData((ItemStack)stack).m_128471_("shearing")) {
            return false;
        }
        return super.onBlockStartBreak(stack, pos, player);
    }

    public boolean isMultiMining(ItemStack stack) {
        return StackUtil.getNbtData((ItemStack)stack).m_128471_("treeChopping");
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)IC2Textures.getMappedEntriesItem((String)"gravisuit", (String)"tools").get("advanced_chainsaw");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        CompoundTag nbt;
        ItemStack stack;
        if (IC2.KEYBOARD.isModeSwitchKeyDown(playerIn)) {
            stack = playerIn.m_21120_(handIn);
            nbt = stack.m_41784_();
            boolean treeChopping = nbt.m_128471_("treeChopping");
            if (IC2.PLATFORM.isSimulating()) {
                nbt.m_128379_("treeChopping", !treeChopping);
                playerIn.m_5661_((Component)this.translate("message.tree_chopping." + (!treeChopping ? "on" : "off")), false);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        }
        if (IC2.KEYBOARD.isSneakKeyDown(playerIn)) {
            stack = playerIn.m_21120_(handIn);
            nbt = stack.m_41784_();
            boolean shearing = nbt.m_128471_("shearing");
            if (IC2.PLATFORM.isSimulating()) {
                nbt.m_128379_("shearing", !shearing);
                playerIn.m_5661_((Component)this.translate("message.shearing." + (!shearing ? "on" : "off")), false);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addToolTip(ItemStack stack, Player player, TooltipFlag type, ToolTipHelper helper) {
        CompoundTag nbt = StackUtil.getNbtData((ItemStack)stack);
        boolean treeChopping = nbt.m_128471_("treeChopping");
        helper.addSimpleToolTip("item_info.tree_chopping_mode", new Object[]{this.translate("item_info." + (treeChopping ? "enabled" : "disabled"))});
        boolean shearing = nbt.m_128471_("shearing");
        helper.addSimpleToolTip("item_info.shearing_mode", new Object[]{this.translate("item_info." + (shearing ? "enabled" : "disabled"))});
        helper.addKeybindingTooltip(this.buildKeyDescription(KeyHelper.MODE_KEY, KeyHelper.RIGHT_CLICK, "item_info.tree_chopping_toggle", new Object[0]));
        helper.addKeybindingTooltip(this.buildKeyDescription(KeyHelper.SNEAK_KEY, KeyHelper.RIGHT_CLICK, "item_info.shear_toggle", new Object[0]));
        super.addToolTip(stack, player, type, helper);
        helper.addSimpleToolTip(Component.m_237115_((String)"item_info.modified_by_gravisuit").m_130940_(ChatFormatting.RED));
    }
}

