/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.gravisuit.util.render;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import ic2.api.items.electric.ElectricItem;
import ic2.core.IC2;
import ic2.core.item.wearable.armor.electric.ElectricPackArmor;
import ic2.core.item.wearable.base.IC2ElectricJetpackBase;
import ic2.core.item.wearable.base.IC2JetpackBase;
import ic2.core.item.wearable.base.IC2ModularElectricArmor;
import ic2.core.utils.helpers.StackUtil;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import trinsdar.gravisuit.items.armor.IGravitationJetpack;
import trinsdar.gravisuit.items.armor.IHasOverlay;
import trinsdar.gravisuit.util.GravisuitConfig;

public class GraviSuitOverlay
implements IGuiOverlay {
    public static Minecraft mc;
    public static Font fontRenderer;
    static int offset;

    public GraviSuitOverlay(Minecraft mc) {
        GraviSuitOverlay.mc = mc;
        fontRenderer = mc.f_91062_;
    }

    public void render(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        IHasOverlay overlay;
        IC2ModularElectricArmor armor;
        ItemStack headArmor;
        Item item;
        if (GravisuitConfig.HUD_MODE.get() == GravisuitConfig.HudMode.OFF) {
            return;
        }
        LocalPlayer player = GraviSuitOverlay.mc.f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stackArmor = player.m_6844_(EquipmentSlot.CHEST);
        Item itemArmor = stackArmor.m_41720_();
        if (!(GravisuitConfig.HUD_MODE.get() != GravisuitConfig.HudMode.REQUIRES_HUD_UPGRADE || (item = (headArmor = player.m_6844_(EquipmentSlot.HEAD)).m_41720_()) instanceof IC2ModularElectricArmor && (armor = (IC2ModularElectricArmor)item).isHudEnabled(headArmor))) {
            return;
        }
        int yPos1 = 3;
        if (GravisuitConfig.POSITIONS.get() == GravisuitConfig.Positions.BOTTOMLEFT || GravisuitConfig.POSITIONS.get() == GravisuitConfig.Positions.BOTTOMRIGHT || GravisuitConfig.POSITIONS.get() == GravisuitConfig.Positions.BOTTOMLEFT_HOTBAR || GravisuitConfig.POSITIONS.get() == GravisuitConfig.Positions.BOTTOMRIGHT_HOTBAR) {
            Objects.requireNonNull(fontRenderer);
            yPos1 = screenHeight - (9 * 4 + 6);
        }
        Objects.requireNonNull(fontRenderer);
        int yPos2 = yPos1 + 9 + 2;
        Objects.requireNonNull(fontRenderer);
        int yPos3 = yPos2 + 9 + 2;
        Objects.requireNonNull(fontRenderer);
        int yPos4 = yPos3 + 9 + 2;
        if (itemArmor instanceof IHasOverlay && (overlay = (IHasOverlay)itemArmor).isEnabled(stackArmor)) {
            IC2ModularElectricArmor armor2;
            IC2JetpackBase base;
            CompoundTag tag = overlay.getArmorNBT(stackArmor, true);
            if (itemArmor instanceof IC2ModularElectricArmor && (base = (armor2 = (IC2ModularElectricArmor)itemArmor).getJetpack(stackArmor)) != null) {
                itemArmor = base;
            }
            int currentCharge = ElectricItem.MANAGER.getCharge(stackArmor);
            int maxCapacity = ElectricItem.MANAGER.getCapacity(stackArmor);
            int energyLevel = (int)Math.round((double)currentCharge / (double)maxCapacity * 100.0);
            String energyString = "message.info.energy";
            MutableComponent energyToDisplay = GraviSuitOverlay.formatComplexMessage(ChatFormatting.YELLOW, energyString, GraviSuitOverlay.getEnergyTextColor(energyLevel), energyLevel + "%");
            boolean isEngineOn = !tag.m_128471_("disabled");
            String engineStatus = isEngineOn ? "message.info.on" : "message.info.off";
            ChatFormatting engineStatusColor = isEngineOn ? ChatFormatting.GREEN : ChatFormatting.RED;
            String engineString = "message.info.jetpack.engine";
            MutableComponent engineToDisplay = GraviSuitOverlay.formatComplexMessage(ChatFormatting.YELLOW, engineString, engineStatusColor, engineStatus);
            String hoverModeS = GraviSuitOverlay.getWorkStatus(stackArmor);
            ChatFormatting hoverModeC = GraviSuitOverlay.getWorkStatusColor(stackArmor);
            String hoverString = "message.info.jetpack.hover";
            MutableComponent hoverToDisplay = GraviSuitOverlay.formatComplexMessage(ChatFormatting.YELLOW, hoverString, hoverModeC, hoverModeS);
            boolean isGraviEngineOn = tag.m_128471_("engine_on");
            String graviEngineStatus = isGraviEngineOn ? "message.info.on" : "message.info.off";
            ChatFormatting graviEngineStatusColor = isGraviEngineOn ? ChatFormatting.GREEN : ChatFormatting.RED;
            String graviEngineString = "message.info.gravitation";
            MutableComponent graviEngineToDisplay = GraviSuitOverlay.formatComplexMessage(ChatFormatting.AQUA, graviEngineString, graviEngineStatusColor, graviEngineStatus);
            if (itemArmor instanceof ElectricPackArmor) {
                fontRenderer.m_92763_(poseStack, (Component)energyToDisplay, (float)GraviSuitOverlay.getXOffset(energyToDisplay.getString(), gui.getMinecraft().m_91268_()), (float)yPos1, 0);
            }
            if (itemArmor instanceof IC2ElectricJetpackBase) {
                fontRenderer.m_92763_(poseStack, (Component)energyToDisplay, (float)GraviSuitOverlay.getXOffset(energyToDisplay.getString(), gui.getMinecraft().m_91268_()), (float)yPos1, 0);
                fontRenderer.m_92763_(poseStack, (Component)engineToDisplay, (float)GraviSuitOverlay.getXOffset(engineToDisplay.getString(), gui.getMinecraft().m_91268_()), (float)yPos2, 0);
                fontRenderer.m_92763_(poseStack, (Component)hoverToDisplay, (float)GraviSuitOverlay.getXOffset(hoverToDisplay.getString(), gui.getMinecraft().m_91268_()), (float)yPos3, 0);
            }
            if (itemArmor instanceof IGravitationJetpack) {
                fontRenderer.m_92763_(poseStack, (Component)graviEngineToDisplay, (float)GraviSuitOverlay.getXOffset(graviEngineToDisplay.getString(), gui.getMinecraft().m_91268_()), (float)yPos4, 0);
            }
        }
    }

    private static int getXOffset(String value, Window window) {
        return switch ((GravisuitConfig.Positions)GravisuitConfig.POSITIONS.get()) {
            default -> throw new IncompatibleClassChangeError();
            case GravisuitConfig.Positions.TOPLEFT, GravisuitConfig.Positions.BOTTOMLEFT -> offset;
            case GravisuitConfig.Positions.TOPRIGHT, GravisuitConfig.Positions.BOTTOMRIGHT -> window.m_85445_() - 3 - fontRenderer.m_92895_(value);
            case GravisuitConfig.Positions.BOTTOMLEFT_HOTBAR -> window.m_85445_() / 2 - 91 - 3 - fontRenderer.m_92895_(value);
            case GravisuitConfig.Positions.BOTTOMRIGHT_HOTBAR -> window.m_85445_() / 2 + 3 + 91;
            case GravisuitConfig.Positions.TOPMIDDLE -> (int)((float)window.m_85445_() * 0.5f) - fontRenderer.m_92895_(value) / 2;
        };
    }

    public boolean or(Item compare, Item ... items) {
        for (Item item : items) {
            if (compare != item) continue;
            return true;
        }
        return false;
    }

    public static ChatFormatting getEnergyTextColor(double energyLevel) {
        if (energyLevel == 100.0) {
            return ChatFormatting.GREEN;
        }
        if (energyLevel <= 100.0 && energyLevel > 50.0) {
            return ChatFormatting.GOLD;
        }
        if (energyLevel <= 50.0) {
            return ChatFormatting.RED;
        }
        return null;
    }

    public static MutableComponent formatSimpleMessage(ChatFormatting color, String text) {
        return Component.m_237115_((String)text).m_130940_(color);
    }

    public static MutableComponent formatComplexMessage(ChatFormatting color1, String text1, ChatFormatting color2, String text2) {
        return GraviSuitOverlay.formatSimpleMessage(color1, text1).m_7220_((Component)GraviSuitOverlay.formatSimpleMessage(color2, text2));
    }

    private static IC2JetpackBase.HoverMode getHoverStatus(ItemStack stack) {
        CompoundTag tag = stack.m_41720_() instanceof IC2ModularElectricArmor ? StackUtil.getNbtData((ItemStack)stack).m_128469_("jetpack_data") : StackUtil.getNbtData((ItemStack)stack);
        IC2JetpackBase.HoverMode hoverMode = IC2JetpackBase.HoverMode.byIndex((int)tag.m_128445_("HoverMode"));
        if (IC2.KEYBOARD.isAltKeyDown((Player)GraviSuitOverlay.mc.f_91074_)) {
            hoverMode = hoverMode == IC2JetpackBase.HoverMode.NONE ? IC2JetpackBase.HoverMode.BASIC : IC2JetpackBase.HoverMode.NONE;
        }
        return hoverMode;
    }

    public static String getWorkStatus(ItemStack stack) {
        IC2JetpackBase.HoverMode mode = GraviSuitOverlay.getHoverStatus(stack);
        if (mode == IC2JetpackBase.HoverMode.BASIC) {
            return "message.info.basic";
        }
        if (mode == IC2JetpackBase.HoverMode.ADV) {
            return "message.info.adv";
        }
        return "message.info.off";
    }

    public static ChatFormatting getWorkStatusColor(ItemStack stack) {
        IC2JetpackBase.HoverMode mode = GraviSuitOverlay.getHoverStatus(stack);
        if (mode == IC2JetpackBase.HoverMode.BASIC) {
            return ChatFormatting.GREEN;
        }
        if (mode == IC2JetpackBase.HoverMode.ADV) {
            return ChatFormatting.AQUA;
        }
        return ChatFormatting.RED;
    }

    @Deprecated
    public static int getCharge(ItemStack stack) {
        CompoundTag nbt = StackUtil.getNbtData((ItemStack)stack);
        int e = nbt.m_128451_("charge");
        return e;
    }

    static {
        offset = 3;
    }
}

