/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.ui.Element;
import snownee.jade.impl.ui.TextElement;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.OverlayRenderer;

public class CustomTextElement
extends TextElement {
    private float scale = 1.0f;
    private int zOffset;
    private boolean centered;

    public CustomTextElement(Component component) {
        super(component);
    }

    public Vec2 getSize() {
        Font font = Minecraft.m_91087_().f_91062_;
        float f = (float)font.m_92852_(this.text) * this.scale;
        Objects.requireNonNull(font);
        return new Vec2(f, 9.0f * this.scale + 1.0f);
    }

    public void render(PoseStack matrixStack, float x, float y, float maxX, float maxY) {
        matrixStack.m_85836_();
        Font font = Minecraft.m_91087_().f_91062_;
        if (this.centered) {
            x += (maxX - x - (float)font.m_92852_(this.text) * this.scale) / 2.0f;
        }
        matrixStack.m_85837_((double)x, (double)(y + this.scale), (double)this.zOffset);
        matrixStack.m_85841_(this.scale, this.scale, 1.0f);
        DisplayHelper.INSTANCE.drawText(matrixStack, this.text, 0.0f, 0.0f, OverlayRenderer.normalTextColorRaw);
        matrixStack.m_85849_();
    }

    public CustomTextElement toSpecial() {
        return this;
    }

    public Element scale(float scale) {
        this.scale = scale;
        return this;
    }

    public Element zOffset(int zOffset) {
        this.zOffset = zOffset;
        return this;
    }

    public Element centered(boolean centered) {
        this.centered = centered;
        return this;
    }
}

