/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.providers;

import ic2.api.tiles.readers.IEUStorage;
import ic2.core.block.base.tiles.BaseTileEntity;
import ic2.core.block.machines.tiles.hv.MassFabricatorTileEntity;
import ic2.core.block.machines.tiles.hv.TeleporterTileEntity;
import ic2.core.block.machines.tiles.lv.ElectrolyzerTileEntity;
import ic2.core.block.machines.tiles.mv.ChargedElectrolyzerTileEntity;
import ic2.core.block.storage.tiles.CreativeSourceTileEntity;
import ic2.core.utils.math.ColorUtils;
import ic2.jadeplugin.base.JadeHelper;
import ic2.jadeplugin.base.interfaces.IInfoProvider;
import ic2.jadeplugin.helpers.Formatter;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EUStorageInfo
implements IInfoProvider {
    public static final EUStorageInfo THIS = new EUStorageInfo();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void addInfo(JadeHelper helper, BlockEntity blockEntity, Player player) {
        if (!(blockEntity instanceof BaseTileEntity)) return;
        BaseTileEntity baseTile = (BaseTileEntity)blockEntity;
        if (baseTile instanceof CreativeSourceTileEntity) {
            helper.bar(1, 1, (Component)this.translate("ic2.probe.eu.storage.name", new Object[]{"Infinite"}).m_130940_(ChatFormatting.WHITE), ColorUtils.RED);
            return;
        }
        if (baseTile instanceof IEUStorage) {
            IEUStorage storage = (IEUStorage)baseTile;
            if (!(baseTile instanceof ElectrolyzerTileEntity || baseTile instanceof ChargedElectrolyzerTileEntity || baseTile instanceof MassFabricatorTileEntity)) {
                helper.bar(storage.getStoredEU(), storage.getMaxEU(), (Component)this.translate("ic2.probe.eu.storage.full.name", new Object[]{Formatter.formatInt(storage.getStoredEU(), 4), Formatter.formatInt(storage.getMaxEU(), 4)}), ColorUtils.RED);
                return;
            }
        }
        if (!(baseTile instanceof TeleporterTileEntity)) return;
        TeleporterTileEntity tp = (TeleporterTileEntity)baseTile;
        helper.bar((int)tp.getAvailableEnergy(), (int)tp.getMaxEnergy(), (Component)this.translate("ic2.probe.eu.storage.name", new Object[]{Formatter.formatInt((int)tp.getAvailableEnergy(), 4)}).m_130940_(ChatFormatting.WHITE), ColorUtils.RED);
    }
}

