/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.providers;

import ic2.core.block.generators.tiles.FuelBoilerTileEntity;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.utils.helpers.Formatters;
import ic2.core.utils.math.ColorUtils;
import ic2.jadeplugin.base.JadeHelper;
import ic2.jadeplugin.base.interfaces.IInfoProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FuelBoilerInfo
implements IInfoProvider {
    public static final FuelBoilerInfo THIS = new FuelBoilerInfo();

    @Override
    public void addInfo(JadeHelper helper, BlockEntity blockEntity, Player player) {
        if (blockEntity instanceof FuelBoilerTileEntity) {
            FuelBoilerTileEntity fuelBoiler = (FuelBoilerTileEntity)blockEntity;
            int fuel = fuelBoiler.getFuel();
            int maxFuel = fuelBoiler.getMaxFuel();
            int heat = fuelBoiler.getHeat();
            int maxHeat = fuelBoiler.getMaxHeat();
            helper.bar(fuel, maxFuel, (Component)Component.m_237115_((String)"ic2.probe.fuel.storage.name").m_130946_(String.valueOf(fuel)), ColorUtils.DARK_GRAY);
            if (PlayerHandler.getHandler((Player)player).hasThermometer()) {
                helper.bar(heat, maxHeat, (Component)Component.m_237110_((String)"ic2.probe.reactor.heat.name", (Object[])new Object[]{heat / 30, Formatters.EU_READER_FORMAT.format((double)maxHeat / 30.0)}), ColorUtils.GREEN);
            }
            helper.addTankInfo((BlockEntity)fuelBoiler);
            if (!fuelBoiler.isValid) {
                long time = fuelBoiler.clockTime(512);
                helper.bar((int)time, 512, (Component)this.translate("ic2.multiblock.reform.next", new Object[]{512L - time}), ColorUtils.GRAY);
            }
        }
    }
}

