/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.providers;

import ic2.core.block.machines.tiles.lv.PumpTileEntity;
import ic2.core.utils.helpers.Formatters;
import ic2.jadeplugin.base.JadeHelper;
import ic2.jadeplugin.base.interfaces.IInfoProvider;
import ic2.jadeplugin.helpers.TextFormatter;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PumpInfo
implements IInfoProvider {
    public static final PumpInfo THIS = new PumpInfo();

    @Override
    public void addInfo(JadeHelper helper, BlockEntity blockEntity, Player player) {
        if (blockEntity instanceof PumpTileEntity) {
            PumpTileEntity pump = (PumpTileEntity)blockEntity;
            helper.maxIn(pump.getMaxInput());
            helper.usage(pump.getPumpCost());
            helper.defaultText("ic2.probe.pump.pressure", TextFormatter.GREEN.literal("100"));
            helper.defaultText("ic2.probe.pump.amount", TextFormatter.GREEN.literal(Formatters.EU_FORMAT.format(800L)));
            int progress = pump.getPumpProgress();
            int maxProgress = pump.getPumpMaxProgress();
            if (progress > 0) {
                helper.bar(progress, maxProgress, (Component)this.translate("ic2.probe.progress.full.name", new Object[]{progress, maxProgress}).m_130946_("t"), -16733185);
            }
            helper.addTankInfo((BlockEntity)pump);
        }
    }
}

