/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.providers;

import ic2.api.tiles.teleporter.TeleporterTarget;
import ic2.core.IC2;
import ic2.core.block.machines.tiles.hv.TeleporterTileEntity;
import ic2.core.utils.helpers.Formatters;
import ic2.core.utils.helpers.SanityHelper;
import ic2.core.utils.helpers.TeleportUtil;
import ic2.jadeplugin.base.JadeHelper;
import ic2.jadeplugin.base.interfaces.IInfoProvider;
import ic2.jadeplugin.helpers.Formatter;
import ic2.jadeplugin.helpers.TextFormatter;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TeleporterInfo
implements IInfoProvider {
    public static final TeleporterInfo THIS = new TeleporterInfo();

    @Override
    public void addInfo(JadeHelper helper, BlockEntity blockEntity, Player player) {
        if (blockEntity instanceof TeleporterTileEntity) {
            TeleporterTileEntity teleport = (TeleporterTileEntity)blockEntity;
            helper.defaultText((Component)this.translate("ic2.probe.teleporter.type", new Object[]{this.translate("ic2.probe.teleporter.type." + teleport.getProbeSendType().name().toLowerCase())}));
            TeleporterTarget target = teleport.target;
            int cost = teleport.getBaseCost();
            long availableEnergy = teleport.getAvailableEnergy();
            if (target == null) {
                helper.defaultText("ic2.probe.teleporter.no_target", new Object[0]);
            } else if (!teleport.hasMatchingType()) {
                helper.defaultText("ic2.probe.teleporter.invalid_target", new Object[0]);
            } else {
                helper.defaultText("ic2.probe.teleporter.target", SanityHelper.toPascalCase((String)target.getDimension().m_135782_().m_135815_()), target.getTargetPosition().m_123341_(), target.getTargetPosition().m_123342_(), target.getTargetPosition().m_123343_());
            }
            int displayCost = cost;
            switch (teleport.getProbeSendType()) {
                case ENTITY: {
                    displayCost = TeleportUtil.getWeightOfEntity((Entity)player, (boolean)IC2.CONFIG.teleporterKeepItems.get()) * cost * 5;
                    break;
                }
                case FLUID: {
                    this.displayCapacity(helper, "ic2.probe.teleporter.capacity.fluid", (double)availableEnergy / (double)cost * 10.0);
                    break;
                }
                case ITEM: {
                    this.displayCapacity(helper, "ic2.probe.teleporter.capacity.item", (double)availableEnergy / (double)cost / 100.0 * 64.0);
                    break;
                }
                case SPAWNER: {
                    displayCost = cost * 25000;
                }
            }
            helper.defaultText("ic2.probe.teleporter.cost", TextFormatter.GREEN.literal(Formatters.EU_FORMAT.format(displayCost)));
        }
    }

    private void displayCapacity(JadeHelper helper, String translationKey, double value) {
        helper.defaultText("ic2.probe.teleporter.capacity", this.translate(translationKey, new Object[]{Formatter.formatNumber(value, 6)}));
    }
}

