/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.providers.transport;

import ic2.core.block.transport.item.tubes.FilteredExtractionTubeTileEntity;
import ic2.jadeplugin.base.JadeHelper;
import ic2.jadeplugin.base.interfaces.IInfoProvider;
import ic2.jadeplugin.helpers.TextFormatter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FilteredExtractionTubeInfo
implements IInfoProvider {
    public static final FilteredExtractionTubeInfo THIS = new FilteredExtractionTubeInfo();

    @Override
    public void addInfo(JadeHelper helper, BlockEntity blockEntity, Player player) {
        if (blockEntity instanceof FilteredExtractionTubeTileEntity) {
            FilteredExtractionTubeTileEntity filteredExtraction = (FilteredExtractionTubeTileEntity)blockEntity;
            ArrayList<FilteredExtractionTubeTileEntity.FilterEntry> generalFilter = new ArrayList<FilteredExtractionTubeTileEntity.FilterEntry>();
            ArrayList<FilteredExtractionTubeTileEntity.FilterEntry> metaFilter = new ArrayList<FilteredExtractionTubeTileEntity.FilterEntry>();
            for (FilteredExtractionTubeTileEntity.FilterEntry entry : filteredExtraction.filters) {
                if (!this.hasFlags(entry)) {
                    generalFilter.add(entry);
                    continue;
                }
                metaFilter.add(entry);
            }
            if (!generalFilter.isEmpty()) {
                List<ItemStack> stacks = generalFilter.stream().map(FilteredExtractionTubeTileEntity.FilterEntry::getStack).toList();
                helper.grid(stacks, (Component)TextFormatter.GOLD.translate("info.tube.filter"));
            }
            if (!metaFilter.isEmpty()) {
                metaFilter.forEach(filter -> {
                    boolean checkNBT = (filter.getFlags() & 0x10) != 0;
                    boolean checkFluid = (filter.getFlags() & 0x80) != 0;
                    boolean checkDurability = (filter.getFlags() & 0x100) != 0;
                    int keepItem = filter.getKeepItems();
                    TextFormatter meta = TextFormatter.GREEN;
                    helper.text((Component)TextFormatter.GOLD.translate("info.tube.filter.meta"));
                    helper.appendItem(filter.getStack());
                    helper.appendText((Component)this.string(" ").m_7220_((Component)(checkNBT ? meta.literal("*nbt ") : Component.m_237119_())).m_7220_((Component)(checkFluid ? meta.literal("*fluid ") : Component.m_237119_())).m_7220_((Component)(checkDurability ? meta.literal("*meta ") : Component.m_237119_())).m_7220_((Component)(keepItem > 0 ? TextFormatter.WHITE.translate("info.tube.keep", keepItem) : Component.m_237119_())));
                });
            }
            boolean whitelist = filteredExtraction.whitelist;
            boolean redstoneControl = filteredExtraction.sensitive;
            helper.text((Component)TextFormatter.GOLD.translate("info.tube.whitelist", this.status(whitelist)));
            helper.text((Component)TextFormatter.GOLD.translate("info.tube.redstone", this.status(redstoneControl)));
            if (redstoneControl) {
                boolean comparator = filteredExtraction.comparator;
                boolean pulse = filteredExtraction.pulse;
                helper.text((Component)TextFormatter.LIGHT_PURPLE.translate("info.tube.comparator", this.status(comparator)));
                helper.text((Component)TextFormatter.LIGHT_PURPLE.translate("info.tube.pulse", this.status(pulse)));
            }
        }
    }

    public boolean hasFlags(FilteredExtractionTubeTileEntity.FilterEntry entry) {
        boolean checkNBT = (entry.getFlags() & 0x10) != 0;
        boolean checkFluid = (entry.getFlags() & 0x80) != 0;
        boolean checkDurability = (entry.getFlags() & 0x100) != 0;
        int keepItem = entry.getKeepItems();
        return checkNBT || checkFluid || checkDurability || keepItem > 0;
    }
}

