/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.page.abstr;

import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.page.abstr.PageDoubleRecipe;

public abstract class PageDoubleRecipeRegistry<T extends Recipe<?>>
extends PageDoubleRecipe<T> {
    private final RecipeType<? extends T> recipeType;

    public PageDoubleRecipeRegistry(RecipeType<? extends T> recipeType) {
        this.recipeType = recipeType;
    }

    @Nullable
    private T getRecipe(ResourceLocation id) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return null;
        }
        RecipeManager manager = Minecraft.m_91087_().f_91073_.m_7465_();
        return (T)((Recipe)manager.m_44043_(id).filter(recipe -> recipe.m_6671_() == this.recipeType).orElse(null));
    }

    @Override
    protected T loadRecipe(BookContentsBuilder builder, BookEntry entry, ResourceLocation res) {
        if (res == null) {
            return null;
        }
        T tempRecipe = this.getRecipe(res);
        if (tempRecipe == null) {
            tempRecipe = this.getRecipe(new ResourceLocation("crafttweaker", res.m_135815_()));
        }
        if (tempRecipe != null) {
            entry.addRelevantStack(builder, tempRecipe.m_8043_(), this.pageNum);
            return tempRecipe;
        }
        PatchouliAPI.LOGGER.warn("Recipe {} (of type {}) not found", (Object)res, (Object)Registry.f_122864_.m_7981_(this.recipeType));
        return null;
    }
}

