/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.item.PatchouliItems;

public class ItemModBook
extends Item {
    public static final String TAG_BOOK = "patchouli:book";

    public ItemModBook() {
        super(new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40753_));
    }

    public static float getCompletion(ItemStack stack) {
        Book book = ItemModBook.getBook(stack);
        float progression = 0.0f;
        if (book != null) {
            int totalEntries = 0;
            int unlockedEntries = 0;
            for (BookEntry entry : book.getContents().entries.values()) {
                if (entry.isSecret()) continue;
                ++totalEntries;
                if (entry.isLocked()) continue;
                ++unlockedEntries;
            }
            progression = (float)unlockedEntries / Math.max(1.0f, (float)totalEntries);
        }
        return progression;
    }

    public static ItemStack forBook(Book book) {
        return ItemModBook.forBook(book.id);
    }

    public static ItemStack forBook(ResourceLocation book) {
        ItemStack stack = new ItemStack((ItemLike)PatchouliItems.BOOK);
        CompoundTag cmp = new CompoundTag();
        cmp.m_128359_(TAG_BOOK, book.toString());
        stack.m_41751_(cmp);
        return stack;
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        String tabName = tab.m_40783_();
        BookRegistry.INSTANCE.books.values().forEach(b -> {
            if (!(b.noBook || b.isExtension || tab != CreativeModeTab.f_40754_ && !b.creativeTab.equals(tabName))) {
                items.add((Object)ItemModBook.forBook(b));
            }
        });
    }

    public String getCreatorModId(ItemStack stack) {
        Book book = ItemModBook.getBook(stack);
        if (book != null) {
            return book.owner.getId();
        }
        return Registry.f_122827_.m_7981_((Object)this).m_135827_();
    }

    public static Book getBook(ItemStack stack) {
        ResourceLocation res = ItemModBook.getBookId(stack);
        if (res == null) {
            return null;
        }
        return BookRegistry.INSTANCE.books.get(res);
    }

    private static ResourceLocation getBookId(ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_(TAG_BOOK)) {
            return null;
        }
        String bookStr = stack.m_41783_().m_128461_(TAG_BOOK);
        return ResourceLocation.m_135820_((String)bookStr);
    }

    public Component m_7626_(ItemStack stack) {
        Book book = ItemModBook.getBook(stack);
        if (book != null) {
            return Component.m_237115_((String)book.name);
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        Book book;
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        ResourceLocation rl = ItemModBook.getBookId(stack);
        if (flagIn.m_7050_()) {
            tooltip.add((Component)Component.m_237113_((String)("Book ID: " + rl)).m_130940_(ChatFormatting.GRAY));
        }
        if ((book = ItemModBook.getBook(stack)) != null && !book.getContents().isErrored()) {
            tooltip.add((Component)book.getSubtitle().m_130940_(ChatFormatting.GRAY));
        } else if (book == null) {
            if (rl == null) {
                tooltip.add((Component)Component.m_237115_((String)"item.patchouli.guide_book.undefined").m_130940_(ChatFormatting.DARK_GRAY));
            } else {
                tooltip.add((Component)Component.m_237110_((String)"item.patchouli.guide_book.invalid", (Object[])new Object[]{rl}).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        Book book = ItemModBook.getBook(stack);
        if (book == null) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        if (playerIn instanceof ServerPlayer) {
            PatchouliAPI.get().openBookGUI((ServerPlayer)playerIn, book.id);
            SoundEvent sfx = PatchouliSounds.getSound(book.openSound, PatchouliSounds.BOOK_OPEN);
            playerIn.m_5496_(sfx, 1.0f, (float)(0.7 + Math.random() * 0.4));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }
}

