#version 120

#define composite2
#define gbuffers_terrain
#include "shaders.settings"

varying vec4 color;
varying vec4 normal;
varying float lmcoord;

uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;

#ifdef TAA
uniform float viewWidth;
uniform float viewHeight;
vec2 texelSize = vec2(1.0/viewWidth,1.0/viewHeight);
uniform int framemod8;
const vec2[8] offsets = vec2[8](vec2(1./8.,-3./8.),
								vec2(-1.,3.)/8.,
								vec2(5.0,1.)/8.,
								vec2(-3,-5.)/8.,
								vec2(-5.,5.)/8.,
								vec2(-7.,-1.)/8.,
								vec2(3,7.)/8.,
								vec2(7.,-7.)/8.);
#endif

void main() {
	
	lmcoord = gl_MultiTexCoord1.x/255.0;

	normal.a = 0.02;
	normal.xyz = normalize(gl_NormalMatrix * gl_Normal);

	color = gl_Color;

	gl_Position = gl_ProjectionMatrix * gbufferModelView * gbufferModelViewInverse * gl_ModelViewMatrix * gl_Vertex;
#ifdef TAA
	gl_Position.xy += offsets[framemod8] * gl_Position.w*texelSize;
#endif

}