/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.memoryleakfix.forge;

import java.lang.reflect.Field;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class MemoryLeakFixExpectPlatformImpl {
    private static final ArtifactVersion MCVERSION;

    public static boolean isModLoaded(String id) {
        return ModList.get().isLoaded(id);
    }

    public static int compareMinecraftToVersion(String version) {
        return MCVERSION.compareTo((Object)new DefaultArtifactVersion(version));
    }

    public static String getMappingType() {
        return MCVERSION.compareTo((Object)new DefaultArtifactVersion("1.16.5")) > 0 ? "forge" : "mcp";
    }

    public static boolean isDevEnvironment() {
        return !FMLLoader.isProduction();
    }

    static {
        String mcVersion;
        try {
            Object versionInfo = FMLLoader.class.getMethod("versionInfo", new Class[0]).invoke(null, new Object[0]);
            mcVersion = (String)versionInfo.getClass().getMethod("mcVersion", new Class[0]).invoke(versionInfo, new Object[0]);
        }
        catch (Exception e) {
            try {
                Field field = FMLLoader.class.getDeclaredField("mcVersion");
                field.setAccessible(true);
                mcVersion = (String)field.get(null);
            }
            catch (Exception ex) {
                throw new RuntimeException("[MemoryLeakFix] Reflection failed at getting the Minecraft version from Forge", ex);
            }
        }
        MCVERSION = new DefaultArtifactVersion(mcVersion);
    }
}

