/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.memoryleakfix.mixinextras.injector.wrapoperation;

import ca.fxco.memoryleakfix.mixinextras.injector.LateApplyingInjectorInfo;
import ca.fxco.memoryleakfix.mixinextras.injector.MixinExtrasInjectionInfo;
import ca.fxco.memoryleakfix.mixinextras.injector.wrapoperation.WrapOperation;
import ca.fxco.memoryleakfix.mixinextras.injector.wrapoperation.WrapOperationApplicatorExtension;
import ca.fxco.memoryleakfix.mixinextras.injector.wrapoperation.WrapOperationInjector;
import ca.fxco.memoryleakfix.mixinextras.utils.ASMUtils;
import ca.fxco.memoryleakfix.mixinextras.utils.CompatibilityHelper;
import ca.fxco.memoryleakfix.mixinextras.utils.InjectorUtils;
import ca.fxco.memoryleakfix.mixinextras.utils.MixinExtrasLogger;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.points.BeforeConstant;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;

@InjectionInfo.AnnotationType(value=WrapOperation.class)
@InjectionInfo.HandlerPrefix(value="wrapOperation")
public class WrapOperationInjectionInfo
extends MixinExtrasInjectionInfo
implements LateApplyingInjectorInfo {
    private static final MixinExtrasLogger LOGGER = MixinExtrasLogger.get("WrapOperation");
    private LateApplyingInjectorInfo injectionInfoToQueue = this;

    public WrapOperationInjectionInfo(MixinTargetContext mixin, MethodNode method, AnnotationNode annotation) {
        super(mixin, method, annotation, WrapOperationInjectionInfo.determineAtKey(mixin, method, annotation));
    }

    protected Injector parseInjector(AnnotationNode injectAnnotation) {
        return new WrapOperationInjector(this);
    }

    public void prepare() {
        super.prepare();
        InjectorUtils.checkForDupedNews(this.targetNodes);
        for (Map.Entry entry : this.targetNodes.entrySet()) {
            Target target = (Target)entry.getKey();
            ListIterator it = ((List)entry.getValue()).listIterator();
            while (it.hasNext()) {
                InjectionNodes.InjectionNode node = (InjectionNodes.InjectionNode)it.next();
                AbstractInsnNode currentTarget = node.getCurrentTarget();
                if (currentTarget.getOpcode() != 187) continue;
                MethodInsnNode initCall = ASMUtils.findInitNodeFor(target, (TypeInsnNode)currentTarget);
                if (initCall == null) {
                    LOGGER.warn("NEW node {} in {} has no init call?", Bytecode.describeNode((AbstractInsnNode)currentTarget), target);
                    it.remove();
                    continue;
                }
                node.decorate("mixinextras_newArgTypes", (Object)Type.getArgumentTypes((String)initCall.desc));
            }
        }
    }

    public void inject() {
        WrapOperationApplicatorExtension.offerInjection((ITargetClassContext)this.mixin.getTarget(), this.injectionInfoToQueue);
    }

    public void postInject() {
    }

    @Override
    public void lateInject() {
        super.inject();
    }

    @Override
    public void latePostInject() {
        super.postInject();
    }

    @Override
    public void wrap(LateApplyingInjectorInfo outer) {
        this.injectionInfoToQueue = outer;
    }

    protected void parseInjectionPoints(List<AnnotationNode> ats) {
        if (this.atKey.equals("at")) {
            super.parseInjectionPoints(ats);
            return;
        }
        Type returnType = Type.getReturnType((String)this.method.desc);
        for (AnnotationNode at : ats) {
            this.injectionPoints.add(new BeforeConstant(CompatibilityHelper.getMixin(this), at, returnType.getDescriptor()));
        }
    }

    private static String determineAtKey(MixinTargetContext mixin, MethodNode method, AnnotationNode annotation) {
        boolean constant;
        boolean at = Annotations.getValue((AnnotationNode)annotation, (String)"at") != null;
        boolean bl = constant = Annotations.getValue((AnnotationNode)annotation, (String)"constant") != null;
        if (at == constant) {
            throw new IllegalStateException(String.format("@WrapOperation injector %s::%s must specify exactly one of `at` and `constant`, got %s.", mixin.getMixin().getClassName(), method.name, at ? "both" : "neither"));
        }
        return at ? "at" : "constant";
    }
}

