/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.fluids.FluidStack;

public interface IRenderedTankUpgrade {
    public void setTankRenderInfoUpdateCallback(Consumer<TankRenderInfo> var1);

    public void forceUpdateTankRenderInfo();

    public static class TankRenderInfo {
        private static final String FLUID_TAG = "fluid";
        private static final String FILL_RATIO_TAG = "fillRatio";
        @Nullable
        private FluidStack fluidStack;
        private float fillRatio;

        public TankRenderInfo() {
            this(null, 0.0f);
        }

        public TankRenderInfo(@Nullable FluidStack fluidStack, float fillRatio) {
            this.fluidStack = fluidStack;
            this.fillRatio = fillRatio;
        }

        public CompoundTag serialize() {
            CompoundTag ret = new CompoundTag();
            if (this.fluidStack != null) {
                ret.m_128365_(FLUID_TAG, (Tag)this.fluidStack.writeToNBT(new CompoundTag()));
                ret.m_128350_(FILL_RATIO_TAG, this.fillRatio);
            }
            return ret;
        }

        public static TankRenderInfo deserialize(CompoundTag tag) {
            if (tag.m_128441_(FLUID_TAG)) {
                return new TankRenderInfo(FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_(FLUID_TAG)), tag.m_128457_(FILL_RATIO_TAG));
            }
            return new TankRenderInfo();
        }

        public void setFluid(FluidStack fluidStack) {
            this.fluidStack = fluidStack.copy();
        }

        public Optional<FluidStack> getFluid() {
            return Optional.ofNullable(this.fluidStack);
        }

        public void setFillRatio(float fillRatio) {
            this.fillRatio = fillRatio;
        }

        public float getFillRatio() {
            return this.fillRatio;
        }
    }
}

