/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.createindustry;

import com.drmangotea.createindustry.CreateTFMGClient;
import com.drmangotea.createindustry.base.TFMGLangPartials;
import com.drmangotea.createindustry.blocks.electricity.base.cables.ElectricNetworkManager;
import com.drmangotea.createindustry.config.TFMGConfigs;
import com.drmangotea.createindustry.items.weapons.explosives.thermite_grenades.fire.TFMGColoredFires;
import com.drmangotea.createindustry.registry.TFMGBlockEntities;
import com.drmangotea.createindustry.registry.TFMGBlocks;
import com.drmangotea.createindustry.registry.TFMGContraptions;
import com.drmangotea.createindustry.registry.TFMGCreativeModeTabs;
import com.drmangotea.createindustry.registry.TFMGEntityTypes;
import com.drmangotea.createindustry.registry.TFMGFluids;
import com.drmangotea.createindustry.registry.TFMGItems;
import com.drmangotea.createindustry.registry.TFMGMobEffects;
import com.drmangotea.createindustry.registry.TFMGPackets;
import com.drmangotea.createindustry.registry.TFMGPaletteBlocks;
import com.drmangotea.createindustry.registry.TFMGParticleTypes;
import com.drmangotea.createindustry.registry.TFMGPotions;
import com.drmangotea.createindustry.registry.TFMGRecipeTypes;
import com.drmangotea.createindustry.registry.TFMGSoundEvents;
import com.drmangotea.createindustry.registry.TFMGTags;
import com.drmangotea.createindustry.worldgen.TFMGConfiguredFeatures;
import com.drmangotea.createindustry.worldgen.TFMGFeatures;
import com.drmangotea.createindustry.worldgen.TFMGOreConfigEntries;
import com.mojang.logging.LogUtils;
import com.simibubi.create.content.fluids.tank.BoilerHeaters;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.LangMerger;
import com.simibubi.create.foundation.data.LangPartial;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.item.TooltipModifier;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Holder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="createindustry")
public class CreateTFMG {
    public static final String MOD_ID = "createindustry";
    public static final String NAME = "Create: The Factory Must Grow";
    public static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"createindustry");
    public static final ElectricNetworkManager NETWORK_MANAGER = new ElectricNetworkManager();
    public static final Logger LOGGER = LogUtils.getLogger();

    public CreateTFMG() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        REGISTRATE.registerEventListeners(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        TFMGBlocks.register();
        TFMGItems.register();
        TFMGBlockEntities.register();
        TFMGEntityTypes.register();
        TFMGCreativeModeTabs.init();
        TFMGFluids.register();
        TFMGTags.init();
        TFMGPaletteBlocks.register();
        TFMGSoundEvents.prepare();
        TFMGContraptions.prepare();
        TFMGOreConfigEntries.init();
        TFMGParticleTypes.register(modEventBus);
        TFMGMobEffects.register(modEventBus);
        TFMGPotions.register(modEventBus);
        TFMGPackets.registerPackets();
        TFMGColoredFires.register(modEventBus);
        TFMGFeatures.register(modEventBus);
        TFMGRecipeTypes.register(modEventBus);
        TFMGConfigs.register(ModLoadingContext.get());
        modEventBus.addListener(CreateTFMG::init);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(EventPriority.LOWEST, CreateTFMG::gatherData);
        modEventBus.addListener(TFMGSoundEvents::register);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> CreateTFMGClient::new);
        modEventBus.addListener(this::clientSetup);
    }

    public static void init(FMLCommonSetupEvent event) {
        TFMGFluids.registerFluidInteractions();
        event.enqueueWork(() -> BoilerHeaters.registerHeater((Block)((Block)TFMGBlocks.FIREBOX.get()), (level, pos, state) -> {
            BlazeBurnerBlock.HeatLevel value = (BlazeBurnerBlock.HeatLevel)state.m_61143_((Property)BlazeBurnerBlock.HEAT_LEVEL);
            if (value == BlazeBurnerBlock.HeatLevel.NONE) {
                return -1.0f;
            }
            if (value == BlazeBurnerBlock.HeatLevel.SEETHING) {
                return 3.0f;
            }
            if (value.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
                return 2.0f;
            }
            return -1.0f;
        }));
    }

    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        gen.m_236039_(true, (DataProvider)new LangMerger(gen, MOD_ID, NAME, (LangPartial[])TFMGLangPartials.values()));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFMGColoredFires.GREEN_FIRE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFMGColoredFires.BLUE_FIRE.get()), (RenderType)RenderType.m_110463_());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Holder<PlacedFeature> initializeOil = TFMGConfiguredFeatures.OIL_PLACED;
            Holder<PlacedFeature> initializeSimulatedOil = TFMGConfiguredFeatures.OIL_DEPOSIT_PLACED;
        });
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("YEEEHAAW");
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, TooltipHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
    }
}

