/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.createindustry.blocks.cogwheeels;

import com.drmangotea.createindustry.registry.TFMGPartialModels;
import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class EncasedAluminumCogInstance
extends KineticBlockEntityInstance<KineticBlockEntity> {
    private boolean large;
    protected RotatingData rotatingModel;
    protected Optional<RotatingData> rotatingTopShaft;
    protected Optional<RotatingData> rotatingBottomShaft;

    public static EncasedAluminumCogInstance small(MaterialManager modelManager, KineticBlockEntity blockEntity) {
        return new EncasedAluminumCogInstance(modelManager, blockEntity, false);
    }

    public static EncasedAluminumCogInstance large(MaterialManager modelManager, KineticBlockEntity blockEntity) {
        return new EncasedAluminumCogInstance(modelManager, blockEntity, true);
    }

    public EncasedAluminumCogInstance(MaterialManager modelManager, KineticBlockEntity blockEntity, boolean large) {
        super(modelManager, blockEntity);
        this.large = large;
    }

    public void init() {
        this.rotatingModel = this.setup((RotatingData)this.getCogModel().createInstance());
        Block block = this.blockState.m_60734_();
        if (!(block instanceof IRotate)) {
            return;
        }
        IRotate def = (IRotate)block;
        this.rotatingTopShaft = Optional.empty();
        this.rotatingBottomShaft = Optional.empty();
        for (Direction d : Iterate.directionsInAxis((Direction.Axis)this.axis)) {
            if (!def.hasShaftTowards((LevelReader)((KineticBlockEntity)this.blockEntity).m_58904_(), ((KineticBlockEntity)this.blockEntity).m_58899_(), this.blockState, d)) continue;
            RotatingData data = this.setup((RotatingData)this.getRotatingMaterial().getModel(AllPartialModels.SHAFT_HALF, this.blockState, d).createInstance());
            if (this.large) {
                data.setRotationOffset(BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)this.axis, (BlockPos)this.pos));
            }
            if (d.m_122421_() == Direction.AxisDirection.POSITIVE) {
                this.rotatingTopShaft = Optional.of(data);
                continue;
            }
            this.rotatingBottomShaft = Optional.of(data);
        }
    }

    public void update() {
        this.updateRotation(this.rotatingModel);
        this.rotatingTopShaft.ifPresent(x$0 -> this.updateRotation((RotatingData)x$0));
        this.rotatingBottomShaft.ifPresent(x$0 -> this.updateRotation((RotatingData)x$0));
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.rotatingModel});
        this.rotatingTopShaft.ifPresent(d -> this.relight(this.pos, new FlatLit[]{d}));
        this.rotatingBottomShaft.ifPresent(d -> this.relight(this.pos, new FlatLit[]{d}));
    }

    public void remove() {
        this.rotatingModel.delete();
        this.rotatingTopShaft.ifPresent(InstanceData::delete);
        this.rotatingBottomShaft.ifPresent(InstanceData::delete);
    }

    protected Instancer<RotatingData> getCogModel() {
        BlockState referenceState = ((KineticBlockEntity)this.blockEntity).m_58900_();
        Direction facing = Direction.m_122387_((Direction.Axis)((Direction.Axis)referenceState.m_61143_((Property)BlockStateProperties.f_61365_)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        PartialModel partial = this.large ? TFMGPartialModels.LARGE_ALUMINUM_COGHWEEL : TFMGPartialModels.ALUMINUM_COGHWEEL;
        return this.getCutoutRotatingMaterial().getModel(partial, referenceState, facing, () -> {
            PoseStack poseStack = new PoseStack();
            ((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)poseStack).centre()).rotateToFace(facing)).multiply(Vector3f.f_122222_.m_122240_(90.0f))).unCentre();
            return poseStack;
        });
    }

    protected Material<RotatingData> getCutoutRotatingMaterial() {
        return this.materialManager.defaultCutout().material(AllMaterialSpecs.ROTATING);
    }
}

