/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.createindustry.blocks.deposits.surface_scanner;

import com.drmangotea.createindustry.base.TFMGTools;
import com.drmangotea.createindustry.registry.TFMGBlocks;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SurfaceScannerBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation,
IWrenchable {
    public List<BlockPos> deposits = new ArrayList<BlockPos>();
    public boolean foundDeposit = false;
    public Optional<BlockPos> closestDeposit = Optional.empty();
    public int locatingTimer = -1;
    public boolean noDepositFound = false;
    int dotTimer = 0;
    int dotCount = 1;
    public LerpedFloat visualAngle = LerpedFloat.angular();
    public float angle = 0.0f;
    public LerpedFloat visualFlagAngle = LerpedFloat.angular();
    public float flagAngle = 0.0f;

    public SurfaceScannerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void manageDots() {
        ++this.dotTimer;
        if (this.dotTimer >= 90) {
            this.dotCount = 3;
            this.dotTimer = 0;
        } else if (this.dotTimer >= 60) {
            this.dotCount = 2;
        } else if (this.dotTimer >= 30) {
            this.dotCount = 1;
        }
    }

    public void setVisualAngles() {
        this.visualAngle.chase((double)this.angle, (double)0.2f, LerpedFloat.Chaser.EXP);
        this.visualAngle.tickChaser();
        this.visualFlagAngle.chase((double)this.flagAngle, (double)0.8f, LerpedFloat.Chaser.EXP);
        this.visualFlagAngle.tickChaser();
    }

    public void tick() {
        super.tick();
        this.foundDeposit = !this.deposits.isEmpty();
        this.angle %= 360.0f;
        if (this.getSpeed() == 0.0f) {
            this.locatingTimer = -1;
            this.foundDeposit = false;
            this.noDepositFound = false;
            this.closestDeposit = Optional.empty();
            return;
        }
        if (this.locatingTimer == -1 && this.deposits.isEmpty()) {
            this.locatingTimer = 600;
            this.closestDeposit = Optional.empty();
        }
        int range = 50;
        if (this.locatingTimer >= 0) {
            for (int i = 0; i < 10; ++i) {
                BlockPos checkedPos = new BlockPos(this.m_58899_().m_123341_() + this.f_58857_.f_46441_.m_188503_(range * 2) - 50, -64, this.m_58899_().m_123343_() + this.f_58857_.f_46441_.m_188503_(range * 2) - 50);
                if (!this.f_58857_.m_8055_(checkedPos).m_60713_((Block)TFMGBlocks.OIL_DEPOSIT.get())) continue;
                this.deposits.add(checkedPos);
            }
            if (this.locatingTimer > 0) {
                --this.locatingTimer;
            }
            if (this.deposits.isEmpty()) {
                this.closestDeposit = Optional.empty();
            }
        }
        this.setVisualAngles();
        this.manageDots();
        if (this.locatingTimer == 0 && this.foundDeposit) {
            this.closestDeposit = Optional.of(this.deposits.get(0));
            for (BlockPos deposit : this.deposits) {
                float distanceClosest = TFMGTools.getDistance(this.m_58899_(), this.closestDeposit.get(), true);
                float distanceCurrent = TFMGTools.getDistance(this.m_58899_(), deposit, true);
                if (!(distanceCurrent < distanceClosest)) continue;
                this.closestDeposit = Optional.of(deposit);
            }
            float zDistance = this.closestDeposit.get().m_123343_() - this.m_58899_().m_123343_();
            float xDistance = this.closestDeposit.get().m_123341_() - this.m_58899_().m_123341_();
            if (zDistance < 10.0f && zDistance > -10.0f && xDistance < 10.0f && xDistance > -10.0f) {
                this.flagAngle = 90.0f;
                return;
            }
            this.angle = (float)Math.toDegrees(Math.atan(xDistance / zDistance));
            if (this.m_58899_().m_123343_() < this.closestDeposit.get().m_123343_()) {
                this.angle += 180.0f;
            }
            if (this.angle == 90.0f) {
                this.angle = -90.0f;
                return;
            }
            if (this.angle == -90.0f) {
                this.angle = 90.0f;
            }
            return;
        }
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        this.flagAngle = 0.0f;
        this.angle = 0.0f;
        this.foundDeposit = false;
        this.deposits = new ArrayList<BlockPos>();
        this.locatingTimer = -1;
        return InteractionResult.SUCCESS;
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.getSpeed() == 0.0f) {
            Lang.translate((String)"goggles.surface_scanner.no_rotation", (Object[])new Object[0]).style(ChatFormatting.DARK_RED).forGoggles(tooltip);
            return true;
        }
        if (this.getSpeed() > 0.0f && !this.foundDeposit && this.locatingTimer == 0) {
            Lang.translate((String)"goggles.surface_scanner.no_deposit", (Object[])new Object[0]).style(ChatFormatting.RED).space().forGoggles(tooltip);
            return true;
        }
        if (this.closestDeposit.isPresent() && this.foundDeposit) {
            Lang.translate((String)"goggles.surface_scanner.deposit_found", (Object[])new Object[0]).style(ChatFormatting.DARK_GREEN).space().forGoggles(tooltip);
            Lang.translate((String)"goggles.surface_scanner.distance", (Object[])new Object[]{Float.valueOf(TFMGTools.getDistance(this.m_58899_(), this.closestDeposit.get(), true))}).style(ChatFormatting.GREEN).forGoggles(tooltip, 1);
        }
        if (this.locatingTimer > 0) {
            if (this.dotCount == 1) {
                Lang.translate((String)"goggles.surface_scanner.scanning_surface", (Object[])new Object[0]).style(ChatFormatting.GOLD).add(Lang.translate((String)"goggles.misc.dot_one", (Object[])new Object[0])).forGoggles(tooltip);
            }
            if (this.dotCount == 2) {
                Lang.translate((String)"goggles.surface_scanner.scanning_surface", (Object[])new Object[0]).style(ChatFormatting.GOLD).add(Lang.translate((String)"goggles.misc.dot_two", (Object[])new Object[0])).forGoggles(tooltip);
            }
            if (this.dotCount == 3) {
                Lang.translate((String)"goggles.surface_scanner.scanning_surface", (Object[])new Object[0]).style(ChatFormatting.GOLD).add(Lang.translate((String)"goggles.misc.dot_three", (Object[])new Object[0])).forGoggles(tooltip);
            }
        }
        return true;
    }
}

