/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.createindustry.blocks.electricity.energy_components.timed_relay;

import com.drmangotea.createindustry.CreateTFMG;
import com.drmangotea.createindustry.base.util.MaxBlockVoltage;
import com.drmangotea.createindustry.blocks.electricity.base.VoltageAlteringBlockEntity;
import com.drmangotea.createindustry.blocks.electricity.base.cables.ElectricalNetwork;
import com.drmangotea.createindustry.blocks.electricity.base.cables.IElectric;
import com.drmangotea.createindustry.blocks.electricity.traffic_light.TimerScrollBehaviour;
import com.drmangotea.createindustry.blocks.electricity.traffic_light.TrafficLightScrollSlot;
import com.drmangotea.createindustry.registry.TFMGBlockEntities;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TimedRelayBlockEntity
extends VoltageAlteringBlockEntity {
    protected ScrollValueBehaviour timerLength;
    public int timer = 250;
    public boolean powerToggle = false;

    public TimedRelayBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.timerLength = new TimerScrollBehaviour((Component)Lang.translateDirect((String)"timed_relay.timer_length", (Object[])new Object[0]), this, new TrafficLightScrollSlot()).between(2, 72000);
        this.timerLength.withFormatter(this::format);
        this.timerLength.setValue(2);
        behaviours.add((BlockEntityBehaviour)this.timerLength);
    }

    @Override
    public int getOutputVoltage() {
        return this.timer;
    }

    private String format(int value) {
        if (value < 60) {
            return value + "t";
        }
        if (value < 1200) {
            return value / 20 + "s";
        }
        return value / 20 / 60 + "m";
    }

    @Override
    public boolean outputAllowed() {
        return false;
    }

    @Override
    public void lazyTick() {
        IElectric be;
        super.lazyTick();
        this.getOrCreateElectricNetwork().requestEnergy(this);
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).hasElectricitySlot(facing.m_122424_())) {
            ElectricalNetwork.sendEnergy(this, be);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        CreateTFMG.LOGGER.debug("mogus: " + this.timer);
        if (this.timer > 0) {
            --this.timer;
        }
        if (this.timer == 0) {
            IElectric be;
            boolean bl = this.powerToggle = !this.powerToggle;
            if (this.powerToggle) {
                Create.LOGGER.debug("turning on");
            }
            if (!this.powerToggle) {
                Create.LOGGER.debug("turning off");
            }
            this.powerToggle = !this.powerToggle;
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
            if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).hasElectricitySlot(facing.m_122424_())) {
                be.getOrCreateElectricNetwork().updateNetworkVoltage();
            }
            this.timer = this.timerLength.getValue();
        }
    }

    @Override
    public void setVoltage(int value, boolean update) {
        IElectric be;
        super.setVoltage(value, update);
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).hasElectricitySlot(facing.m_122424_())) {
            be.getOrCreateElectricNetwork().updateNetworkVoltage();
        }
    }

    @Override
    public int maxVoltage() {
        return MaxBlockVoltage.MAX_VOLTAGES.get(TFMGBlockEntities.RESISTOR.get());
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_();
    }
}

