/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.createindustry.blocks.electricity.voltmeter;

import com.drmangotea.createindustry.blocks.electricity.base.cables.IElectric;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class VoltMeterBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public LerpedFloat angle = LerpedFloat.angular();
    public int voltage = 0;
    public int range = 500;

    public VoltMeterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void tick() {
        super.tick();
        if (!this.f_58857_.f_46443_) {
            return;
        }
        BlockEntity beBehind = this.f_58857_.m_7702_(this.m_58899_().m_121945_(((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_()));
        if (beBehind instanceof IElectric) {
            IElectric be = (IElectric)beBehind;
            this.voltage = Math.min(be.getVoltage(), this.range);
        } else {
            this.voltage = 0;
        }
        float value = (float)Math.abs(this.voltage) / (float)this.getRange();
        if (value > 1.0f) {
            value = 1.0f;
        }
        float targetAngle = Math.abs(value * 180.0f);
        this.angle.chase((double)Math.abs(targetAngle), (double)0.05f, LerpedFloat.Chaser.EXP);
        this.angle.tickChaser();
    }

    public int getRange() {
        return this.range;
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("range", this.range);
        compound.m_128350_("angle", (float)Math.abs(this.voltage) / (float)this.getRange());
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.range = compound.m_128451_("range");
        this.angle.setValue((double)compound.m_128457_("angle"));
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.translate((String)"goggles.voltmeter", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
        Lang.translate((String)"goggles.voltmeter.voltage", (Object[])new Object[]{Math.min(this.voltage, this.range)}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        Lang.translate((String)"goggles.voltmeter.range", (Object[])new Object[]{this.range}).style(ChatFormatting.DARK_AQUA).forGoggles(tooltip, 1);
        return true;
    }
}

