/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.createindustry.blocks.engines.diesel;

import com.drmangotea.createindustry.blocks.engines.diesel.DieselEngineBlock;
import com.drmangotea.createindustry.blocks.engines.diesel.DieselEngineBlockEntity;
import com.drmangotea.createindustry.registry.TFMGPartialModels;
import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.steamEngine.PoweredShaftBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class DieselEngineRenderer
extends SafeBlockEntityRenderer<DieselEngineBlockEntity> {
    public DieselEngineRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(DieselEngineBlockEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (Backend.canUseInstancing((Level)te.m_58904_())) {
            return;
        }
        Float angle = te.getTargetAngle();
        if (angle == null) {
            return;
        }
        BlockState blockState = te.m_58900_();
        Direction facing = DieselEngineBlock.getFacing(blockState);
        Direction.Axis facingAxis = facing.m_122434_();
        Direction.Axis axis = Direction.Axis.Y;
        PoweredShaftBlockEntity shaft = te.getShaft();
        if (shaft != null) {
            axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)shaft);
        }
        boolean roll90 = facingAxis.m_122479_() && axis == Direction.Axis.Y || facingAxis.m_122478_() && axis == Direction.Axis.Z;
        float sine = Mth.m_14031_((float)angle.floatValue());
        float sine2 = Mth.m_14031_((float)(angle.floatValue() - 1.5707964f));
        float piston = (1.0f - sine) / 4.0f * 24.0f / 16.0f;
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        this.transformed(TFMGPartialModels.DIESEL_ENGINE_PISTON, blockState, facing, roll90).translate(0.0, (double)piston, 0.0).light(light).renderInto(ms, vb);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.transformed(TFMGPartialModels.DIESEL_ENGINE_LINKAGE, blockState, facing, roll90).centre()).translate(0.0, 1.0, 0.0).unCentre()).translate(0.0, (double)piston, 0.0).translate(0.0, 0.25, 0.5).rotateX((double)(sine2 * 23.0f))).translate(0.0, -0.25, -0.5).light(light).renderInto(ms, vb);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.transformed(AllPartialModels.ENGINE_CONNECTOR, blockState, facing, roll90).translate(0.0, 2.0, 0.0).centre()).rotateXRadians((double)(-angle.floatValue() + 1.5707964f))).unCentre()).light(light).renderInto(ms, vb);
    }

    private SuperByteBuffer transformed(PartialModel model, BlockState blockState, Direction facing, boolean roll90) {
        return (SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBufferer.partial((PartialModel)model, (BlockState)blockState).centre()).rotateY((double)AngleHelper.horizontalAngle((Direction)facing))).rotateX((double)(AngleHelper.verticalAngle((Direction)facing) + 90.0f))).rotateY(roll90 ? -90.0 : 0.0)).unCentre();
    }

    public int m_142163_() {
        return 128;
    }
}

